/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.UserActionsIcon;
import org.eclipse.rse.internal.useractions.UserActionsPersistenceUtil;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.swt.graphics.Image;

public class SystemUDActionManager
extends SystemUDBaseManager
implements ITreeContentProvider {
    private static final String XE_ROOT = "Actions";
    private static final String XE_ACTION = "Action";

    public SystemUDActionManager(SystemUDActionSubsystem udas) {
        super(udas);
    }

    protected boolean isUserActionsManager() {
        return true;
    }

    public Image getNewImage() {
        return UserActionsIcon.USERACTION_NEW.getImage();
    }

    protected String getNewNodeLabel() {
        return this.getActionSubSystem().getNewNodeActionLabel();
    }

    protected boolean doMigration(ISystemProfile profile, String oldRelease) {
        return this.getActionSubSystem().doActionsMigration(profile, oldRelease);
    }

    public String getDocumentRootTagName() {
        return XE_ROOT;
    }

    protected boolean uppercaseName() {
        return false;
    }

    public boolean supportsProfiles() {
        return true;
    }

    public SystemXMLElementWrapper[] primeDocument(ISystemProfile profile) {
        if (profile.isDefaultPrivate()) {
            return this.getActionSubSystem().primeDefaultActions(this, profile);
        }
        return null;
    }

    protected IFolder getDocumentFolder(ISubSystemConfiguration subsystemFactory, ISystemProfile profile) {
        return UserActionsPersistenceUtil.getUserActionsFolder(profile.getName(), subsystemFactory);
    }

    public void setFolder(String profileName, String factoryId) {
        this.importCaseFolder = UserActionsPersistenceUtil.getUserActionsFolder(profileName, factoryId);
    }

    public SystemUDActionElement addAction(ISystemProfile profile, String name, int domain) {
        return (SystemUDActionElement)super.addElement(profile, domain, name);
    }

    public SystemUDActionElement[] getActions(Vector v, ISystemProfile profile, int domain) {
        if ((v = super.getXMLWrappers(v, domain, profile)) == null) {
            return new SystemUDActionElement[0];
        }
        SystemUDActionElement[] actions = new SystemUDActionElement[v.size()];
        int idx = 0;
        while (idx < actions.length) {
            actions[idx] = (SystemUDActionElement)v.elementAt(idx);
            ++idx;
        }
        return actions;
    }

    public SystemUDActionElement[] getAllActions(Vector v, ISystemProfile profile) {
        if (!this.getActionSubSystem().supportsDomains()) {
            return this.getActions(v, profile, -1);
        }
        if (v == null) {
            v = new Vector();
        }
        int nbrDomains = this.getActionSubSystem().getMaximumDomain() + 1;
        int domain = 0;
        while (domain < nbrDomains) {
            super.getXMLWrappers(v, domain, profile);
            ++domain;
        }
        SystemUDActionElement[] actions = new SystemUDActionElement[v.size()];
        int idx = 0;
        while (idx < actions.length) {
            actions[idx] = (SystemUDActionElement)v.elementAt(idx);
            ++idx;
        }
        return actions;
    }

    public String getTagName() {
        return XE_ACTION;
    }

    public SystemXMLElementWrapper createElementWrapper(IPropertySet xmlElementToWrap, ISystemProfile profile, int domain) {
        SystemUDActionElement elementWrapper = new SystemUDActionElement(xmlElementToWrap, this, profile, domain);
        return elementWrapper;
    }
}

