/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.util.Strings;

public final class TranslationInputValidator {
    private TranslationInputValidator() {
    }

    public static IStatus validateDefaultTranslation(CharSequence defaultTranslation) {
        if (Strings.isEmpty((CharSequence)defaultTranslation)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "The default translation must be set.", null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateNlsKey(TranslationStoreStack project, String key) {
        return TranslationInputValidator.validateNlsKey(project, key, null);
    }

    public static IStatus validateNlsKey(TranslationStoreStack project, String key, Collection<String> exceptions) {
        Optional e;
        if (Strings.isBlank((CharSequence)key)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "Please specify a key.", null);
        }
        if ((exceptions == null || !exceptions.contains(key)) && (e = project.translation(key)).isPresent()) {
            if (((ITranslationEntry)e.get()).store().isEditable()) {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "A key '" + key + "' already exists!", null);
            }
            return new Status(2, "org.eclipse.scout.sdk.s2e.ui", -1, "The key '" + key + "' overrides an inherited entry.", null);
        }
        if (!ITranslation.KEY_REGEX.matcher(key).matches()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "The key name is not valid.", null);
        }
        return Status.OK_STATUS;
    }
}

