/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.action;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.TranslationNewDialog;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.swt.widgets.Shell;

public class TranslationNewAction
extends Action {
    private final ITranslation m_initialEntry;
    private final TranslationStoreStack m_stack;
    private final Shell m_shell;
    private final NlsTableController m_controller;
    private ITranslation m_createdTranslation;

    public TranslationNewAction(Shell shell, TranslationStoreStack stack, NlsTableController controller) {
        this(shell, stack, null, controller);
    }

    public TranslationNewAction(Shell shell, TranslationStoreStack stack, ITranslation entry) {
        this(shell, stack, entry, null);
    }

    protected TranslationNewAction(Shell shell, TranslationStoreStack stack, ITranslation entry, NlsTableController controller) {
        super("New Translation...");
        this.m_controller = controller;
        this.m_shell = (Shell)Ensure.notNull((Object)shell);
        this.m_stack = (TranslationStoreStack)Ensure.notNull((Object)stack);
        this.m_initialEntry = Optional.ofNullable(entry).orElseGet(() -> new Translation(""));
        this.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("text_add.png"));
        this.setEnabled(stack.isEditable());
    }

    public void run() {
        TranslationNewDialog dialog = new TranslationNewDialog(this.m_shell, this.m_stack, this.m_initialEntry);
        dialog.show().ifPresent(entry -> {
            this.m_createdTranslation = entry;
            this.m_stack.addNewTranslation(entry, (ITranslationStore)dialog.getSelectedStore().orElse(null));
            if (this.m_controller == null) {
                EclipseEnvironment.runInEclipseEnvironment((arg_0, arg_1) -> ((TranslationStoreStack)this.m_stack).flush(arg_0, arg_1));
            } else {
                this.m_controller.reveal(entry.key());
            }
        });
    }

    public Optional<ITranslation> getCreatedTranslation() {
        return Optional.ofNullable(this.m_createdTranslation);
    }
}

