/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.internal.editor.DefaultFontStyler;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DTableColumnLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final String CHECKED_IMAGE = "table/checked";
    public static final String UNCHECKED_IMAGE = "table/unchecked";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    DColumn column;

    static {
        imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(CHECKED_IMAGE))));
        imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(UNCHECKED_IMAGE))));
    }

    public DTableColumnLabelProvider(DColumn column) {
        this.column = column;
    }

    public Color getBackground(Object element) {
        Color result = null;
        if (this.column != null) {
            RGBValues rgb;
            Option<DCell> optionalCell = this.getDCell(element);
            Option styleToApply = null;
            if (optionalCell.some()) {
                styleToApply = new DCellQuery((DCell)optionalCell.get()).getBackgroundStyleToApply();
            } else if (element instanceof DLine) {
                styleToApply = TableHelper.getBackgroundStyleToApply((DLine)((DLine)element), (DColumn)this.column);
            }
            if (styleToApply != null && styleToApply.some() && (rgb = ((DTableElementStyle)styleToApply.get()).getBackgroundColor()) != null) {
                result = VisualBindingManager.getDefault().getColorFromRGBValues(rgb);
            }
        }
        return result;
    }

    public Font getFont(Object element) {
        if (this.column != null) {
            Option<DCell> optionalCell = this.getDCell(element);
            Option styleToApply = null;
            if (optionalCell.some()) {
                styleToApply = new DCellQuery((DCell)optionalCell.get()).getForegroundStyleToApply();
            } else if (element instanceof DLine) {
                styleToApply = TableHelper.getForegroundStyleToApply((DLine)((DLine)element), (DColumn)this.column);
            }
            if (styleToApply != null && styleToApply.some()) {
                int size = ((DTableElementStyle)styleToApply.get()).getLabelSize();
                EList labelFormat = new ArrayList();
                if (((DTableElementStyle)styleToApply.get()).getLabelFormat() != null) {
                    labelFormat = ((DTableElementStyle)styleToApply.get()).getLabelFormat();
                } else {
                    labelFormat.clear();
                }
                return VisualBindingManager.getDefault().getFontFromLabelFormatAndSize((List)labelFormat, size);
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.column != null) {
            RGBValues rgb;
            Option<DCell> optionalCell = this.getDCell(element);
            Option styleToApply = null;
            if (optionalCell.some()) {
                styleToApply = new DCellQuery((DCell)optionalCell.get()).getForegroundStyleToApply();
            } else if (element instanceof DLine) {
                styleToApply = TableHelper.getForegroundStyleToApply((DLine)((DLine)element), (DColumn)this.column);
            }
            if (styleToApply != null && styleToApply.some() && (rgb = ((DTableElementStyle)styleToApply.get()).getForegroundColor()) != null) {
                return VisualBindingManager.getDefault().getColorFromRGBValues(rgb);
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (this.column != null) {
            Option optionalCell;
            boolean isNotMany;
            DLine line = null;
            if (element instanceof DCell) {
                line = ((DCell)element).getLine();
            } else if (element instanceof DLine) {
                line = (DLine)element;
            }
            EStructuralFeature feature = TableHelper.getEStructuralFeature((DLine)line, (DColumn)this.column);
            EClassifier eClassifier = TableHelper.getEClassifier((DLine)line, (DColumn)this.column);
            boolean bl = isNotMany = feature != null && !feature.isMany();
            if (isNotMany && eClassifier instanceof EDataType && ("Boolean".equals(((EDataType)eClassifier).getName()) || "EBoolean".equals(((EDataType)eClassifier).getName())) && (optionalCell = TableHelper.getCell((DLine)line, (DColumn)this.column)).some()) {
                return this.getImage(Boolean.parseBoolean(((DCell)optionalCell.get()).getLabel()));
            }
        }
        return null;
    }

    public String getText(Object element) {
        String result = "";
        Option<DCell> optionalCell = this.getDCell(element);
        if (optionalCell.some()) {
            result = ((DCell)optionalCell.get()).getLabel();
        }
        return result;
    }

    protected Option<DCell> getDCell(Object element) {
        Option optionalCell = Options.newNone();
        if (element instanceof DLine) {
            DLine line = (DLine)element;
            optionalCell = TableHelper.getCell((DLine)line, (DColumn)this.column);
        } else if (element instanceof DCell) {
            optionalCell = Options.newSome((Object)((DCell)element));
        }
        return optionalCell;
    }

    private Image getImage(boolean isSelected) {
        String key = isSelected ? CHECKED_IMAGE : UNCHECKED_IMAGE;
        return imageRegistry.get(key);
    }

    public boolean isProvideColumn(DColumn currentColumn) {
        return this.column.equals(currentColumn);
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        DefaultFontStyler styler = new DefaultFontStyler(this.getFont(element), this.getForeground(element), this.getBackground(element), this.getUnderline(element), this.getStrikeout(element));
        if (text == null) {
            text = "";
        }
        StyledString styledString = new StyledString(text, (StyledString.Styler)styler);
        return styledString;
    }

    private boolean getStrikeout(Object element) {
        if (this.column != null) {
            EList labelFormat;
            Option<DCell> optionalCell = this.getDCell(element);
            Option styleToApply = null;
            if (optionalCell.some()) {
                styleToApply = new DCellQuery((DCell)optionalCell.get()).getForegroundStyleToApply();
            } else if (element instanceof DLine) {
                styleToApply = TableHelper.getForegroundStyleToApply((DLine)((DLine)element), (DColumn)this.column);
            }
            if (styleToApply != null && styleToApply.some() && (labelFormat = ((DTableElementStyle)styleToApply.get()).getLabelFormat()) != null) {
                return labelFormat.contains(FontFormat.STRIKE_THROUGH_LITERAL);
            }
        }
        return false;
    }

    private boolean getUnderline(Object element) {
        if (this.column != null) {
            EList labelFormat;
            Option<DCell> optionalCell = this.getDCell(element);
            Option styleToApply = null;
            if (optionalCell.some()) {
                styleToApply = new DCellQuery((DCell)optionalCell.get()).getForegroundStyleToApply();
            } else if (element instanceof DLine) {
                styleToApply = TableHelper.getForegroundStyleToApply((DLine)((DLine)element), (DColumn)this.column);
            }
            if (styleToApply != null && styleToApply.some() && (labelFormat = ((DTableElementStyle)styleToApply.get()).getLabelFormat()) != null) {
                return labelFormat.contains(FontFormat.UNDERLINE_LITERAL);
            }
        }
        return false;
    }
}

