/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.session;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.internal.commands.CloseUISessionCommand;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class CloseSessionsAction
extends SelectionListenerAction {
    private Collection<URI> sessionsToCloseURI = new LinkedHashSet<URI>();

    public CloseSessionsAction(String text) {
        super(text);
    }

    public CloseSessionsAction(String text, Session session) {
        super(text);
        this.sessionsToCloseURI.add(session.getSessionResource().getURI());
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null) {
            for (Session concernedSession : Iterables.filter((Iterable)selection.toList(), Session.class)) {
                this.sessionsToCloseURI.add(concernedSession.getSessionResource().getURI());
            }
            if (!selection.isEmpty()) {
                super.selectionChanged((IStructuredSelection)new StructuredSelection());
            }
        }
        return !this.sessionsToCloseURI.isEmpty();
    }

    public void run() {
        super.run();
        for (URI sessionToCloseURI : this.sessionsToCloseURI) {
            Session session = SessionManager.INSTANCE.getExistingSession(sessionToCloseURI);
            if (session == null) continue;
            this.internalClose(session);
        }
        this.sessionsToCloseURI.clear();
    }

    private void internalClose(Session session) {
        CloseUISessionCommand operation = new CloseUISessionCommand(session);
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.CloseSessionsAction_error, e), (Throwable)e));
        }
        catch (InterruptedException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.CloseSessionsAction_error, e), (Throwable)e));
        }
        if (session.isOpen()) {
            session.close((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

