/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.internal.Grid;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.internal.series.SeriesSet;

public class PlotArea
extends Composite
implements PaintListener,
IPlotArea {
    protected Chart chart;
    List<ICustomPaintListener> paintListeners;
    private static final int DEFAULT_BACKGROUND = 1;
    private DisposeListener disposeListener;

    public PlotArea(Chart chart, int style) {
        super((Composite)chart, style | 0x40000 | 0x20000000);
        this.chart = chart;
        this.paintListeners = new ArrayList<ICustomPaintListener>();
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.addPaintListener(this);
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PlotArea.this.dispose();
            }
        };
        chart.addDisposeListener(this.disposeListener);
        chart.setPlotArea(this);
    }

    public void dispose() {
        super.dispose();
        this.chart.removeDisposeListener(this.disposeListener);
    }

    @Override
    public Chart getChart() {
        return this.chart;
    }

    @Deprecated
    public ISeriesSet getSeriesSet() {
        return this.chart.getSeriesSet();
    }

    @Override
    public Control getControl() {
        return this;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        ((SeriesSet)this.getSeriesSet()).compressAllSeries();
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            super.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public void addCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.add(listener);
    }

    @Override
    public void removeCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.remove(listener);
    }

    public void paintControl(PaintEvent e) {
        Object series;
        Point p = this.getSize();
        GC gc = e.gc;
        Color oldBackground = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, p.x, p.y);
        Object[] objectArray = this.chart.getAxisSet().getAxes();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = objectArray[n2];
            ((Grid)axis.getGrid()).draw(gc, p.x, p.y);
            ++n2;
        }
        for (ICustomPaintListener listener : this.paintListeners) {
            if (!listener.drawBehindSeries()) continue;
            listener.paintControl(e);
        }
        objectArray = this.chart.getSeriesSet().getSeries();
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            series = objectArray[n3];
            if (series instanceof IBarSeries) {
                ((Series)series).draw(gc, p.x, p.y);
            }
            ++n3;
        }
        objectArray = this.chart.getSeriesSet().getSeries();
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            series = objectArray[n3];
            if (series instanceof ILineSeries) {
                ((Series)series).draw(gc, p.x, p.y);
            }
            ++n3;
        }
        for (ICustomPaintListener listener : this.paintListeners) {
            if (listener.drawBehindSeries()) continue;
            listener.paintControl(e);
        }
        e.gc.setBackground(oldBackground);
    }
}

