/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.dialogs.AbstractArraySelectionDialog;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;

public class PeerNodeSelectionDialog
extends AbstractArraySelectionDialog
implements IPeerModelListener {
    final String[] services;

    public PeerNodeSelectionDialog(Shell shell) {
        this(shell, (String[])null);
    }

    public PeerNodeSelectionDialog(Shell shell, String[] services) {
        super(shell, IContextHelpIds.PEER_NODE_SELECTION_DIALOG);
        this.services = services;
        ModelManager.getPeerModel().addListener((IPeerModelListener)this);
    }

    protected void dispose() {
        super.dispose();
        ModelManager.getPeerModel().removeListener((IPeerModelListener)this);
    }

    protected Object[] getInput() {
        ArrayList<IPeerNode> peerNodes = new ArrayList<IPeerNode>();
        IPeerNode[] iPeerNodeArray = ModelManager.getPeerModel().getPeerNodes();
        int n = iPeerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IPeerNode peerNode;
                block4: {
                    peerNode = iPeerNodeArray[n2];
                    if (!peerNode.isVisible() || this.getType() != null && !this.getType().equals(peerNode.getPeerType())) break block3;
                    if (this.services == null || this.services.length <= 0) break block4;
                    final AtomicBoolean hasServices = new AtomicBoolean();
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String offlineServices = peerNode.getStringProperty("OfflineServices");
                            String remoteServices = peerNode.getStringProperty("RemoteServices");
                            List<String> offline = offlineServices != null ? Arrays.asList(offlineServices.split(",\\s*")) : Collections.EMPTY_LIST;
                            List<String> remote = remoteServices != null ? Arrays.asList(remoteServices.split(",\\s*")) : null;
                            boolean hasOfflineService = true;
                            String[] stringArray = PeerNodeSelectionDialog.this.services;
                            int n = PeerNodeSelectionDialog.this.services.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String service = stringArray[n2];
                                if (!(hasOfflineService &= remote == null ? offline.contains(service) : remote.contains(service))) break;
                                ++n2;
                            }
                            hasServices.set(hasOfflineService);
                        }
                    });
                    if (!hasServices.get()) break block3;
                }
                peerNodes.add(peerNode);
            }
            ++n2;
        }
        return peerNodes.toArray();
    }

    protected String getType() {
        return null;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.PeerNodeSelectionDialog_dialogTitle;
    }

    @Override
    protected String getTitle() {
        return Messages.PeerNodeSelectionDialog_title;
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.PeerNodeSelectionDialog_message;
    }

    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        this.refresh();
    }

    public void modelDisposed(IPeerModel model) {
    }

    @Override
    protected void updateSelection(ISelection selection) {
    }

    @Override
    protected void createButtonAreaContent(Composite parent) {
    }
}

