/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal.provider;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tips.core.IHtmlTip;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipAction;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.ide.internal.provider.TipsTipProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Tip6_ActionsTip
extends Tip
implements IHtmlTip {
    private TipImage fImage;

    public TipImage getImage() {
        if (this.fImage == null) {
            try {
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                this.fImage = new TipImage(bundle.getEntry("images/tips/actions.png")).setAspectRatio(758, 480, true);
            }
            catch (Exception exception) {}
        }
        return this.fImage;
    }

    public Tip6_ActionsTip(String providerId) {
        super(providerId);
    }

    public List<TipAction> getActions() {
        Runnable runnable = () -> Display.getDefault().syncExec(() -> {
            boolean bl = MessageDialog.openConfirm(null, (String)this.getSubject(), (String)"A dialog was opened.");
        });
        Runnable clock = () -> Display.getDefault().syncExec(() -> {
            boolean bl = MessageDialog.openConfirm(null, (String)this.getSubject(), (String)DateFormat.getTimeInstance().format(Calendar.getInstance().getTime()));
        });
        Runnable runner2 = () -> Display.getDefault().syncExec(() -> {
            PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"myPreferencePage", null, null);
            if (pref != null) {
                pref.open();
            }
        });
        ArrayList<TipAction> actions = new ArrayList<TipAction>();
        actions.add(new TipAction("Clock", "What is the time?", clock, this.getImage("icons/clock.png")));
        actions.add(new TipAction("Open Preferences", "Opens the preferences", runner2, null));
        actions.add(new TipAction("Open Dialog", "Opens a Dialog", runnable, this.getImage("icons/asterisk.png")));
        return actions;
    }

    private TipImage getImage(String pIcon) {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        try {
            return new TipImage(bundle.getEntry(pIcon)).setAspectRatio(1.0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getCreationDate() {
        return TipsTipProvider.getDateFromYYMMDD("09/01/2019");
    }

    public String getSubject() {
        return "Actions";
    }

    public String getHTML() {
        return "<h2>ActionTips</h2>Some tips enable you to start one or more actions. If this is the case then an additional button will be displayed like in this tip. Go ahead and press the button, or choose another action from the drop down menu next to the button. <br><br><br>";
    }
}

