/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ServerRefactoringIssueAcceptor
implements RefactoringIssueAcceptor {
    private List<Issue> issues = CollectionLiterals.newArrayList();

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, URI uri, ResourceSet resourceSet) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, URI resourceUri) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, EObject element) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, EObject element, ITextRegion region) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, Exception exc, Logger log) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, Object ... params) {
        Issue _issue = new Issue();
        Procedures.Procedure1 _function = it -> {
            ((Issue)it).severity = severity;
            ((Issue)it).message = message;
        };
        Issue _doubleArrow = (Issue)ObjectExtensions.operator_doubleArrow((Object)_issue, (Procedures.Procedure1)_function);
        this.issues.add(_doubleArrow);
    }

    protected boolean addIssue(RefactoringIssueAcceptor.Severity severity, String message) {
        Issue _issue = new Issue();
        Procedures.Procedure1 _function = it -> {
            ((Issue)it).severity = severity;
            ((Issue)it).message = message;
        };
        Issue _doubleArrow = (Issue)ObjectExtensions.operator_doubleArrow((Object)_issue, (Procedures.Procedure1)_function);
        return this.issues.add(_doubleArrow);
    }

    public RefactoringIssueAcceptor.Severity getMaximumSeverity() {
        boolean _greaterThan;
        RefactoringIssueAcceptor.Severity _xifexpression = null;
        int _size = this.issues.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> ((Issue)it).severity;
            Issue _minBy = (Issue)IterableExtensions.minBy(this.issues, (Functions.Function1)_function);
            RefactoringIssueAcceptor.Severity _severity = null;
            if (_minBy != null) {
                _severity = _minBy.severity;
            }
            _xifexpression = _severity;
        } else {
            _xifexpression = RefactoringIssueAcceptor.Severity.OK;
        }
        return _xifexpression;
    }

    public ResponseError toResponseError() {
        ResponseError _xblockexpression = null;
        RefactoringIssueAcceptor.Severity maxSeverity = this.getMaximumSeverity();
        ResponseError _responseError = new ResponseError();
        Procedures.Procedure1 _function = it -> {
            String _switchResult = null;
            if (maxSeverity != null) {
                switch (maxSeverity) {
                    case OK: {
                        _switchResult = "Refactoring is possible";
                        break;
                    }
                    case INFO: {
                        _switchResult = "Refactoring is possible";
                        break;
                    }
                    case WARNING: {
                        _switchResult = "Refactoring could cause issues";
                        break;
                    }
                    case ERROR: {
                        _switchResult = "Refactoring has errors";
                        break;
                    }
                    case FATAL: {
                        _switchResult = "Refactoring cannot be performed";
                        break;
                    }
                }
            }
            it.setMessage(_switchResult);
            Functions.Function1 _function_1 = it_1 -> ((Issue)it_1).severity;
            Functions.Function1 _function_2 = it_1 -> ((Issue)it_1).message;
            it.setData((Object)IterableExtensions.join((Iterable)ListExtensions.map((List)ListExtensions.reverse((List)IterableExtensions.sortBy(this.issues, (Functions.Function1)_function_1)), (Functions.Function1)_function_2), (CharSequence)"\n"));
            int _switchResult_1 = 0;
            if (maxSeverity != null) {
                switch (maxSeverity) {
                    case OK: {
                        _switchResult_1 = 0;
                        break;
                    }
                    case INFO: {
                        _switchResult_1 = 0;
                        break;
                    }
                    case WARNING: {
                        _switchResult_1 = 0;
                        break;
                    }
                    case ERROR: {
                        _switchResult_1 = ResponseErrorCode.UnknownErrorCode.getValue();
                        break;
                    }
                    case FATAL: {
                        _switchResult_1 = ResponseErrorCode.UnknownErrorCode.getValue();
                        break;
                    }
                }
            }
            it.setCode(_switchResult_1);
        };
        _xblockexpression = (ResponseError)ObjectExtensions.operator_doubleArrow((Object)_responseError, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public void checkSeverity() {
        boolean _lessThan;
        RefactoringIssueAcceptor.Severity _maximumSeverity = this.getMaximumSeverity();
        boolean bl = _lessThan = _maximumSeverity.compareTo(RefactoringIssueAcceptor.Severity.WARNING) < 0;
        if (_lessThan) {
            ResponseError _responseError = this.toResponseError();
            throw new ResponseErrorException(_responseError);
        }
    }

    public static class Issue {
        private RefactoringIssueAcceptor.Severity severity;
        private String message;
    }
}

