/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.debug.ui.PinElementHandle;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StateChangedEvent;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbPinColorTracker;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class GdbPinProvider
implements IPinProvider {
    private static Map<IPinProvider.IPinElementHandle, IPinProvider.IPinModelListener> gsPinnedHandles = Collections.synchronizedMap(new HashMap());
    private final DsfSession fSession;

    public GdbPinProvider(DsfSession session) {
        this.fSession = session;
        session.getExecutor().execute(() -> this.fSession.addServiceEventListener((Object)this, null));
    }

    public void dispose() {
        try {
            this.fSession.getExecutor().execute(() -> this.fSession.removeServiceEventListener((Object)this));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public static Set<IPinProvider.IPinElementHandle> getPinnedHandles() {
        return gsPinnedHandles.keySet();
    }

    private static IMIExecutionDMContext getExecutionDmc(IDMContext dmc) {
        return (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIExecutionDMContext.class);
    }

    private static IProcesses.IProcessDMContext getProcessDmc(IDMContext dmc) {
        return (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IProcesses.IProcessDMContext.class);
    }

    private IProcesses.IThreadDMData getData(final IProcesses.IThreadDMContext threadDmc) {
        if (threadDmc == null || !this.fSession.isActive()) {
            return null;
        }
        IProcesses.IThreadDMData data = null;
        final DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), this.fSession.getId());
        try {
            try {
                Query<IProcesses.IThreadDMData> query = new Query<IProcesses.IThreadDMData>(){

                    protected void execute(DataRequestMonitor<IProcesses.IThreadDMData> rm) {
                        IProcesses processes = (IProcesses)tracker.getService(IProcesses.class);
                        if (processes != null) {
                            processes.getExecutionData(threadDmc, rm);
                        } else {
                            rm.setData(null);
                            rm.done();
                        }
                    }
                };
                ImmediateInDsfExecutor immediateExecutor = new ImmediateInDsfExecutor(this.fSession.getExecutor());
                immediateExecutor.execute((Runnable)query);
                data = (IProcesses.IThreadDMData)query.get(2L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                GdbUIPlugin.log(e);
                if (tracker != null) {
                    tracker.dispose();
                }
            }
        }
        finally {
            if (tracker != null) {
                tracker.dispose();
            }
        }
        return data;
    }

    private String getLabel(IProcesses.IThreadDMData data) {
        String label = "";
        if (data != null) {
            String name = data.getName();
            String id = data.getId();
            if (name != null && !name.isEmpty()) {
                label = name;
            } else if (id != null && !id.isEmpty()) {
                label = id;
            }
        }
        return label;
    }

    private String getCombinedLabels(IProcesses.IThreadDMContext processDmc, IMIExecutionDMContext execDmc) {
        IProcesses.IThreadDMData processData = this.getData(processDmc);
        String label = this.getLabel(processData);
        if (execDmc != null) {
            String threadId = execDmc.getThreadId();
            label = String.valueOf(label) + (!label.isEmpty() ? ": " : "");
            label = String.valueOf(label) + "Thread [" + threadId + "]";
        }
        return label;
    }

    public boolean isPinnable(IWorkbenchPart part, Object debugContext) {
        if (debugContext instanceof IAdaptable) {
            return ((IAdaptable)debugContext).getAdapter(IDMContext.class) != null;
        }
        return false;
    }

    public IPinProvider.IPinElementHandle pin(IWorkbenchPart part, Object debugContext, IPinProvider.IPinModelListener listener) {
        Object pinContext = debugContext;
        String label = "";
        String sessionId = "";
        IDMContext dmc = null;
        if (debugContext instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)debugContext).getAdapter(IDMContext.class)) != null) {
            sessionId = String.valueOf(dmc.getSessionId()) + ".";
            IMIExecutionDMContext execDmc = GdbPinProvider.getExecutionDmc(dmc);
            IProcesses.IProcessDMContext processDmc = GdbPinProvider.getProcessDmc(dmc);
            label = this.getCombinedLabels((IProcesses.IThreadDMContext)processDmc, execDmc);
            if (execDmc != null) {
                dmc = execDmc;
                pinContext = execDmc;
            } else {
                pinContext = dmc;
            }
        }
        GdbPinElementColorDescriptor colorDesc = new GdbPinElementColorDescriptor(GdbPinColorTracker.INSTANCE.addRef(String.valueOf(sessionId) + label));
        PinElementHandle handle = new PinElementHandle(pinContext, label, (IPinProvider.IPinElementColorDescriptor)colorDesc);
        gsPinnedHandles.put((IPinProvider.IPinElementHandle)handle, listener);
        this.dispatchChangedEvent(dmc);
        return handle;
    }

    public void unpin(IWorkbenchPart part, IPinProvider.IPinElementHandle handle) {
        gsPinnedHandles.remove(handle);
        Object debugContext = handle.getDebugContext();
        if (debugContext instanceof IAdaptable) {
            IDMContext dmc = (IDMContext)((IAdaptable)debugContext).getAdapter(IDMContext.class);
            GdbPinColorTracker.INSTANCE.removeRef(String.valueOf(dmc.getSessionId()) + "." + handle.getLabel());
            this.dispatchChangedEvent(dmc);
        }
    }

    public boolean isPinnedTo(Object debugContext, IPinProvider.IPinElementHandle handle) {
        Object handleDebugContext = handle.getDebugContext();
        if (debugContext instanceof IAdaptable && handleDebugContext instanceof IAdaptable) {
            IDMContext dmc = (IDMContext)((IAdaptable)debugContext).getAdapter(IDMContext.class);
            IDMContext hDmc = (IDMContext)((IAdaptable)handleDebugContext).getAdapter(IDMContext.class);
            if (dmc != null && hDmc != null && dmc.getSessionId().equals(hDmc.getSessionId())) {
                IMIExecutionDMContext execDmc = GdbPinProvider.getExecutionDmc(dmc);
                IProcesses.IProcessDMContext processDmc = GdbPinProvider.getProcessDmc(dmc);
                String label = this.getCombinedLabels((IProcesses.IThreadDMContext)processDmc, execDmc);
                return label.equals(handle.getLabel());
            }
        }
        return false;
    }

    private void dispatchChangedEvent(IDMContext dmc) {
        if (dmc == null) {
            return;
        }
        try {
            DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
            if (session != null && session.isActive()) {
                session.dispatchEvent((Object)new StateChangedEvent(dmc), null);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IStartedDMEvent event) {
        final IDMContext eventDmc = event.getDMContext();
        final IMIExecutionDMContext eventExecDmc = GdbPinProvider.getExecutionDmc(eventDmc);
        final IProcesses.IProcessDMContext eventProcessDmc = GdbPinProvider.getProcessDmc(eventDmc);
        if (eventProcessDmc != null) {
            for (final IPinProvider.IPinElementHandle h : GdbPinProvider.getPinnedHandles()) {
                new Job("Updating pin handler debug context"){
                    {
                        super($anonymous0);
                        this.setPriority(10);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        DsfSession session;
                        IDMContext handleDmc;
                        PinElementHandle handle = (PinElementHandle)h;
                        Object handleDebugContext = handle.getDebugContext();
                        if (handleDebugContext instanceof IAdaptable && (handleDmc = (IDMContext)((IAdaptable)handleDebugContext).getAdapter(IDMContext.class)) != null && ((session = DsfSession.getSession((String)handleDmc.getSessionId())) == null || !session.isActive())) {
                            String handleLabel = handle.getLabel();
                            String label = GdbPinProvider.this.getCombinedLabels((IProcesses.IThreadDMContext)eventProcessDmc, eventExecDmc);
                            if (label.equals(handleLabel)) {
                                IMIExecutionDMContext newDmc = eventExecDmc != null ? eventExecDmc : eventDmc;
                                handle.setDebugContext((Object)newDmc);
                                GdbPinProvider.this.dispatchChangedEvent((IDMContext)newDmc);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(ICommandControlService.ICommandControlShutdownDMEvent event) {
        this.handleInvalidModelContext((IDMEvent<?>)event);
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        this.handleInvalidModelContext((IDMEvent<?>)event);
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        this.handleInvalidModelContext((IDMEvent<?>)event);
    }

    private void handleInvalidModelContext(IDMEvent<?> event) {
        Set<Map.Entry<IPinProvider.IPinElementHandle, IPinProvider.IPinModelListener>> entries = gsPinnedHandles.entrySet();
        for (Map.Entry<IPinProvider.IPinElementHandle, IPinProvider.IPinModelListener> e : entries) {
            IPinProvider.IPinElementHandle handle;
            Object handleObject;
            IPinProvider.IPinModelListener listener = e.getValue();
            if (listener == null || !((handleObject = (handle = e.getKey()).getDebugContext()) instanceof IDMContext)) continue;
            IDMContext handleDmc = (IDMContext)handleObject;
            IDMContext eventDmc = event.getDMContext();
            IMIExecutionDMContext execEventDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)eventDmc, IMIExecutionDMContext.class);
            IMIExecutionDMContext execHandleDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)handleDmc, IMIExecutionDMContext.class);
            if (execEventDmc != null && execHandleDmc != null) {
                if (!execEventDmc.equals(execHandleDmc)) continue;
                this.fireModleChangeEvent(listener, null);
                continue;
            }
            IMIContainerDMContext procEventDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)eventDmc, IMIContainerDMContext.class);
            IMIContainerDMContext procHandleDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)handleDmc, IMIContainerDMContext.class);
            if (procEventDmc != null && procHandleDmc != null) {
                if (!procEventDmc.equals(procHandleDmc)) continue;
                this.fireModleChangeEvent(listener, null);
                continue;
            }
            if (!(eventDmc instanceof ICommandControlService.ICommandControlDMContext)) continue;
            this.fireModleChangeEvent(listener, null);
        }
    }

    private void fireModleChangeEvent(final IPinProvider.IPinModelListener listener, final ISelection selection) {
        new Job("Model Changed"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor arg0) {
                listener.modelChanged(selection);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private static class GdbPinElementColorDescriptor
    implements IPinProvider.IPinElementColorDescriptor {
        int fColor = 0;

        GdbPinElementColorDescriptor(int color) {
            this.fColor = color;
        }

        public int getOverlayColor() {
            return this.fColor;
        }

        public ImageDescriptor getToolbarIconDescriptor() {
            return null;
        }
    }
}

