/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core.qmldir;

import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.qt.core.qmldir.IQDirAST;
import org.eclipse.cdt.qt.core.qmldir.IQDirClassnameCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirDependsCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirDesignerSupportedCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirInternalCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirModuleCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirPluginCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirResourceCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirSingletonCommand;
import org.eclipse.cdt.qt.core.qmldir.IQDirTypeInfoCommand;
import org.eclipse.cdt.qt.core.qmldir.QMLDirectoryParser;

public class QMLDirectoryInfo {
    private String moduleIdentifier;
    private Plugin plugin;
    private String classname;
    private String typeInfo;
    private final Collection<Module> depends = new LinkedList<Module>();
    private final Collection<ResourceFile> resources = new LinkedList<ResourceFile>();
    private boolean designersupported;

    public QMLDirectoryInfo(InputStream input) {
        IQDirAST ast = new QMLDirectoryParser().parse(input);
        for (IQDirCommand c : ast.getCommands()) {
            IQDirCommand rc;
            if (c instanceof IQDirModuleCommand) {
                if (this.moduleIdentifier != null) continue;
                this.moduleIdentifier = ((IQDirModuleCommand)c).getModuleIdentifier().getText();
                continue;
            }
            if (c instanceof IQDirPluginCommand) {
                if (this.plugin != null) continue;
                IQDirPluginCommand pc = (IQDirPluginCommand)c;
                this.plugin = new Plugin(pc.getName().getText(), pc.getPath() != null ? pc.getPath().getText() : null);
                continue;
            }
            if (c instanceof IQDirTypeInfoCommand) {
                if (this.typeInfo != null) continue;
                this.typeInfo = ((IQDirTypeInfoCommand)c).getFile().getText();
                continue;
            }
            if (c instanceof IQDirResourceCommand) {
                rc = (IQDirResourceCommand)c;
                this.resources.add(new ResourceFile(rc.getFile().getText(), rc.getInitialVersion().getVersionString(), false, false));
                continue;
            }
            if (c instanceof IQDirInternalCommand) {
                rc = (IQDirInternalCommand)c;
                this.resources.add(new ResourceFile(rc.getFile().getText(), null, true, false));
                continue;
            }
            if (c instanceof IQDirSingletonCommand) {
                rc = (IQDirSingletonCommand)c;
                this.resources.add(new ResourceFile(rc.getFile().getText(), rc.getInitialVersion().getVersionString(), false, true));
                continue;
            }
            if (c instanceof IQDirDependsCommand) {
                IQDirDependsCommand dc = (IQDirDependsCommand)c;
                this.depends.add(new Module(dc.getModuleIdentifier().getText(), dc.getInitialVersion().getVersionString()));
                continue;
            }
            if (c instanceof IQDirClassnameCommand) {
                if (this.classname != null) continue;
                this.classname = ((IQDirClassnameCommand)c).getIdentifier().getText();
                continue;
            }
            if (!(c instanceof IQDirDesignerSupportedCommand)) continue;
            this.designersupported = true;
        }
    }

    public String getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getTypesFileName() {
        return this.typeInfo;
    }

    public Collection<Module> getDependentModules() {
        return Collections.unmodifiableCollection(this.depends);
    }

    public Collection<ResourceFile> getResources() {
        return Collections.unmodifiableCollection(this.resources);
    }

    public boolean isDesignersupported() {
        return this.designersupported;
    }

    public static class Module {
        private final String name;
        private final String initialVersion;

        public Module(String name, String ver) {
            this.name = name;
            this.initialVersion = ver;
        }

        public String getName() {
            return this.name;
        }

        public String getInitialVersion() {
            return this.initialVersion;
        }
    }

    public static class Plugin {
        private final String name;
        private final Path path;

        private Plugin(String name, String path) {
            this.name = name;
            Path p = null;
            if (path != null) {
                try {
                    p = Paths.get(path, new String[0]);
                }
                catch (InvalidPathException e) {
                    Activator.log(e);
                }
            }
            this.path = p;
        }

        public String getName() {
            return this.name;
        }

        public Path getRelativePath() {
            return this.path;
        }
    }

    public static class ResourceFile {
        private final String name;
        private final boolean internal;
        private final boolean singleton;
        private final String initialVersion;

        private ResourceFile(String name, String ver, boolean internal, boolean singleton) {
            this.name = name;
            this.initialVersion = ver;
            this.internal = internal;
            this.singleton = singleton;
        }

        public String getName() {
            return this.name;
        }

        public String getInitialVersion() {
            return this.initialVersion;
        }

        public boolean isSingleton() {
            return this.singleton;
        }

        public boolean isInternal() {
            return this.internal;
        }
    }
}

