/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LabelFormEntry {
    private Control _nameLabel;
    private Label _valueLabel;
    private FormToolkit _toolkit;
    private int _colSpan;

    public LabelFormEntry(Composite parent, FormToolkit toolkit, int labelStyle, String labelText, int colSpan) {
        this._toolkit = toolkit;
        this._colSpan = colSpan;
        this.createControl(parent, toolkit, labelStyle, labelText);
    }

    private void createControl(Composite parent, FormToolkit toolkit, int labelStyle, String labelText) {
        this._nameLabel = this._toolkit.createLabel(parent, labelText);
        this._nameLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this._valueLabel = this._toolkit.createLabel(parent, "", labelStyle);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout parentLayout = (GridLayout)layout;
            int numColumns = parentLayout.numColumns;
            if (numColumns < 2) {
                return;
            }
            int numSpan = numColumns;
            if (this._colSpan < numColumns && this._colSpan >= 2) {
                numSpan = this._colSpan;
            }
            int valueLabelSpan = numSpan - 1;
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            this._nameLabel.setLayoutData((Object)gd);
            gd = new GridData(768);
            gd.horizontalSpan = valueLabelSpan;
            this._valueLabel.setLayoutData((Object)gd);
        } else if (layout instanceof TableWrapLayout) {
            TableWrapLayout parentLayout = (TableWrapLayout)layout;
            int numColumns = parentLayout.numColumns;
            if (numColumns < 2) {
                return;
            }
            int numSpan = numColumns;
            if (this._colSpan < numColumns && this._colSpan >= 2) {
                numSpan = this._colSpan;
            }
            int valueLabelSpan = numSpan - 1;
            TableWrapData td = new TableWrapData();
            td.valign = 32;
            this._nameLabel.setLayoutData((Object)td);
            td = new TableWrapData(256);
            td.colspan = valueLabelSpan;
            this._valueLabel.setLayoutData((Object)td);
        }
    }

    public Control getNameLabel() {
        return this._nameLabel;
    }

    public Label getValueLabel() {
        return this._valueLabel;
    }
}

