/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectExternalImpl;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.messages.Messages;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitXATransactionPhase1Request;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitXATransactionRequest;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitXATransactionPhase2Request
extends CommitXATransactionRequest {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CommitXATransactionPhase1Request.class);

    public CommitXATransactionPhase2Request(CDOClientProtocol protocol, InternalCDOXATransaction.InternalCDOXACommitContext xaContext) {
        super(protocol, (short)14, xaContext);
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        this.requestingTransactionInfo(out);
        this.requestingIDMapping(out);
    }

    protected void requestingIDMapping(CDODataOutput out) throws IOException {
        InternalCDOXATransaction.InternalCDOXACommitContext context = this.getCommitContext();
        Map requestedIDs = context.getRequestedIDs();
        int size = requestedIDs.size();
        out.writeXInt(size);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Number of ids requested: {0}", new Object[]{size});
        }
        for (Map.Entry entry : requestedIDs.entrySet()) {
            CDOIDTempObjectExternalImpl tempID = (CDOIDTempObjectExternalImpl)entry.getKey();
            URI oldURIExternal = URI.createURI((String)tempID.toURIFragment());
            CDOID oldCDOID = CDOIDUtil.read((String)oldURIExternal.fragment());
            InternalCDOXATransaction.InternalCDOXACommitContext commitContext = context.getTransactionManager().getCommitContext((CDOTransaction)entry.getValue());
            if (commitContext == null) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("CommitTransactionPhase2Request.1"), entry.getValue()));
            }
            CDOID newID = (CDOID)commitContext.getResult().getIDMappings().get(oldCDOID);
            if (newID == null) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("CommitTransactionPhase2Request.2"), oldCDOID.toURIFragment()));
            }
            CDOID newIDExternal = CDOURIUtil.convertExternalCDOID((URI)oldURIExternal, (CDOID)newID);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("ID mapping: {0} --> {1}", new Object[]{tempID.toURIFragment(), newIDExternal.toURIFragment()});
            }
            out.writeCDOID((CDOID)tempID);
            out.writeCDOID(newIDExternal);
            context.getResult().addIDMapping((CDOID)tempID, newIDExternal);
        }
    }

    @Override
    protected CDOSessionProtocol.CommitTransactionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        return this.confirmingCheckError(in);
    }
}

