/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class RoleClassLiteralAccess
extends ClassLiteralAccess {
    MessageSend send;
    ReferenceBinding teamBinding;

    public RoleClassLiteralAccess(ClassLiteralAccess orig, TypeBinding expressionType) {
        super(orig.sourceEnd, orig.type);
        this.constant = orig.constant;
        this.generateMessageSend(expressionType);
    }

    public RoleClassLiteralAccess(SingleTypeReference typeRef) {
        super(typeRef.sourceEnd, typeRef);
    }

    private void generateMessageSend(TypeBinding expressionType) {
        char[][] tokens;
        AstGenerator gen = new AstGenerator(this.type.sourceStart, this.sourceEnd);
        ReferenceBinding roleBinding = (ReferenceBinding)this.type.resolvedType;
        this.teamBinding = roleBinding.enclosingType();
        if (!roleBinding.isValidBinding()) {
            this.resolvedType = expressionType;
            return;
        }
        Reference receiver = RoleTypeBinding.isRoleWithExplicitAnchor(roleBinding) ? ((tokens = ((RoleTypeBinding)roleBinding)._teamAnchor.tokens()).length == 1 ? gen.singleNameReference(tokens[0]) : gen.qualifiedNameReference(tokens)) : gen.qualifiedThisReference(this.teamBinding);
        this.send = gen.messageSend(receiver, CharOperation.concat(IOTConstants.GET_CLASS_PREFIX, roleBinding.sourceName()), new Expression[0]);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.send != null) {
            return this.send.analyseCode(currentScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.send != null) {
            this.send.generateCode(currentScope, codeStream, valueRequired);
        } else if (valueRequired) {
            codeStream.aconst_null();
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.type instanceof ParameterizedSingleTypeReference) {
            this.constant = Constant.NotAConstant;
            ParameterizedSingleTypeReference typeRef = (ParameterizedSingleTypeReference)this.type;
            if (typeRef.token == null) {
                if (typeRef.typeArguments != null) {
                    TypeReference[] typeReferenceArray = typeRef.typeArguments;
                    int n = typeRef.typeArguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TypeReference anchors = typeReferenceArray[n2];
                        ((TypeAnchorReference)anchors).resolveAnchor(scope);
                        ++n2;
                    }
                }
                return null;
            }
            TypeBinding roleType = this.type.resolveType(scope);
            if (roleType != null && roleType.isValidBinding()) {
                this.generateMessageSend(roleType);
            }
        }
        this.targetType = this.type.resolvedType;
        if (this.send != null) {
            this.resolvedType = this.send.resolveType(scope);
        }
        return this.resolvedType;
    }

    public static TypeBinding ensureGetClassMethod(TeamModel teamModel, RoleModel roleModel) {
        TypeDeclaration teamIfc;
        TypeDeclaration teamDecl = teamModel.getAst();
        ReferenceBinding teamBinding = teamModel.getBinding();
        TypeDeclaration roleDecl = roleModel.getAst();
        ReferenceBinding roleBinding = roleModel.getBinding();
        char[] selector = CharOperation.concat(IOTConstants.GET_CLASS_PREFIX, roleBinding.sourceName());
        TypeBinding result = RoleClassLiteralAccess.ensureGetClassMethodPart(teamDecl, teamBinding, roleDecl, roleBinding, selector);
        if (teamBinding.isRole() && (teamIfc = teamBinding.roleModel.getInterfaceAst()) != null) {
            RoleClassLiteralAccess.ensureGetClassMethodPart(teamIfc, teamIfc.binding, roleDecl, roleBinding, selector);
        }
        return result;
    }

    private static TypeBinding ensureGetClassMethodPart(TypeDeclaration teamDecl, ReferenceBinding teamBinding, TypeDeclaration roleDecl, ReferenceBinding roleBinding, char[] selector) {
        SingleTypeReference roleTypeRef;
        MethodBinding[] existingMethods = teamBinding.getMethods(selector);
        if (existingMethods != Binding.NO_METHODS) {
            return existingMethods[0].returnType;
        }
        if (teamDecl == null) {
            throw new InternalCompilerError("Requesting to generate a method for binary type " + String.valueOf(teamBinding.readableName()));
        }
        AstGenerator gen = roleDecl != null ? new AstGenerator(roleDecl.scope.compilerOptions().sourceLevel, roleDecl.sourceStart, roleDecl.sourceEnd) : new AstGenerator(teamDecl.scope.compilerOptions().sourceLevel, teamDecl.sourceStart, teamDecl.sourceEnd);
        TypeVariableBinding[] typeVariables = roleBinding.typeVariables();
        if (typeVariables != Binding.NO_TYPE_VARIABLES) {
            TypeReference[] wildcards = new Wildcard[typeVariables.length];
            int i = 0;
            while (i < typeVariables.length) {
                wildcards[i] = gen.wildcard(0);
                ++i;
            }
            roleTypeRef = gen.parameterizedSingleTypeReference(roleBinding.sourceName(), wildcards, 0);
        } else {
            roleTypeRef = gen.singleTypeReference(roleBinding.sourceName());
        }
        LookupEnvironment environment = teamDecl.scope.environment();
        boolean hasTypeAnnotation = false;
        if (environment.usesNullTypeAnnotations()) {
            roleTypeRef.annotations = new Annotation[][]{{gen.markerAnnotation(environment.getNonNullAnnotationName())}};
            hasTypeAnnotation = true;
        }
        TypeReference[] typeArguments = new TypeReference[]{roleTypeRef};
        MethodDeclaration method = gen.method(teamDecl.compilationResult, teamBinding.isRole() ? 1 : roleBinding.modifiers & 7, gen.parameterizedQualifiedTypeReference(TypeConstants.JAVA_LANG_CLASS, typeArguments), selector, null);
        if (hasTypeAnnotation) {
            method.bits |= 0x100000;
            method.returnType.bits |= 0x100000;
        }
        if (teamBinding.isInterface()) {
            method.modifiers |= 0x1000400;
        } else {
            method.setStatements(new Statement[]{gen.returnStatement(new ClassLiteralAccess(gen.sourceEnd, gen.singleTypeReference(roleBinding.sourceName()), true))});
        }
        AstEdit.addMethod(teamDecl, method);
        return method.returnType.resolvedType;
    }
}

