/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.PrintWriter;
import java.util.List;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

class JSFUtils12
extends JSFUtils {
    protected JSFUtils12(IModelProvider modelProvider) {
        this(JSFVersion.V1_2, modelProvider);
    }

    protected JSFUtils12(JSFVersion jsfVersion, IModelProvider modelProvider) {
        super(jsfVersion, modelProvider);
        if (jsfVersion.compareTo(JSFVersion.V1_2) < 0) {
            throw new IllegalArgumentException("JsfVersion must be at least 1.2");
        }
    }

    public void doVersionSpecificConfigFile(PrintWriter pw) {
        String QUOTE = new String(new char[]{'\"'});
        String schemaVersionString = this.getVersion().toString().replaceAll("\\.", "_");
        pw.write("<?xml version=" + QUOTE + "1.0" + QUOTE + " encoding=" + QUOTE + "UTF-8" + QUOTE + "?>\n\n");
        pw.write("<faces-config\n");
        pw.write("    xmlns=" + QUOTE + "http://java.sun.com/xml/ns/javaee" + QUOTE + "\n");
        pw.write("    xmlns:xsi=" + QUOTE + "http://www.w3.org/2001/XMLSchema-instance" + QUOTE + "\n");
        pw.write("    xsi:schemaLocation=" + QUOTE + String.format("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facesconfig_%s.xsd", schemaVersionString) + QUOTE + "\n");
        pw.write("    version=" + QUOTE + this.getVersion().toString() + QUOTE + ">\n\n");
        pw.write("</faces-config>\n");
    }

    public void updateWebApp(Object webApp, IDataModel config) {
        Object servlet = this.findJSFServlet(webApp);
        servlet = this.createOrUpdateServletRef(webApp, config, servlet);
        List<String> listOfMappings = this.getServletMappings(config);
        this.setUpURLMappings(webApp, listOfMappings, servlet);
        this.setupContextParams(webApp, config);
    }

    public void rollbackWebApp(Object webApp) {
        Object servlet = this.findJSFServlet(webApp);
        if (servlet == null) {
            return;
        }
        this.removeURLMappings(webApp, servlet);
        this.removeJSFContextParams(webApp);
        this.removeJSFServlet(webApp, servlet);
    }
}

