/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagModelLoader;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStandardTaglibLocator
extends AbstractFaceletTaglibLocator {
    private static final Set<String> taglibLocations;
    private static final Set<MyTagRecordDescriptor> DEFAULT_TAGLIBS;
    private HashMap<String, IFaceletTagRecord> _defaultRecords = new HashMap();

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("/std-taglibs/html_basic.taglib.xml");
        set.add("/std-taglibs/html_basic_jcp.taglib.xml");
        set.add("/std-taglibs/composite.taglib.xml");
        set.add("/std-taglibs/composite_jcp.taglib.xml");
        set.add("/std-taglibs/facelets_jsf_core.taglib.xml");
        set.add("/std-taglibs/facelets_jsf_core_jcp.taglib.xml");
        set.add("/std-taglibs/jstl-core.taglib.xml");
        set.add("/std-taglibs/jstl-fn.taglib.xml");
        set.add("/std-taglibs/ui.taglib.xml");
        set.add("/std-taglibs/ui_jcp.taglib.xml");
        taglibLocations = Collections.unmodifiableSet(set);
        HashSet<MyTagRecordDescriptor> taglibs = new HashSet<MyTagRecordDescriptor>();
        for (String location : taglibLocations) {
            try {
                URL url = FaceletCorePlugin.getDefault().getBundle().getEntry(location);
                URL fileURL = FileLocator.toFileURL((URL)url);
                File file = new File(fileURL.getPath());
                InputStream openStream = fileURL.openStream();
                TagModelLoader loader = new TagModelLoader(file.getAbsolutePath());
                loader.loadFromInputStream(openStream);
                FaceletTaglib taglib = loader.getTaglib();
                MyTagRecordDescriptor desc = new MyTagRecordDescriptor((IPath)new Path(fileURL.toString()), taglib);
                taglibs.add(desc);
            }
            catch (Exception e) {
                FaceletCorePlugin.log("Trying to load default taglib for: " + location, e);
            }
        }
        DEFAULT_TAGLIBS = Collections.unmodifiableSet(taglibs);
    }

    public DefaultStandardTaglibLocator() {
        super("", "");
    }

    public void start(IProject project) {
        TagRecordFactory factory = new TagRecordFactory(project, false);
        for (MyTagRecordDescriptor desc : DEFAULT_TAGLIBS) {
            IFaceletTagRecord record = factory.createRecords(desc.getTaglib(), desc);
            if (record == null) continue;
            this._defaultRecords.put(record.getURI(), record);
        }
        super.start((Object)project);
    }

    @Override
    protected Map<String, ? extends IFaceletTagRecord> doLocate(IProject context) {
        return Collections.unmodifiableMap(this._defaultRecords);
    }

    private static class MyTagRecordDescriptor
    extends IFaceletTagRecord.TagRecordDescriptor {
        private final IPath _path;
        private final FaceletTaglib _taglib;

        public MyTagRecordDescriptor(IPath path, FaceletTaglib taglib) {
            super(IFaceletTagRecord.TagRecordDescriptor.Source.JAR);
            this._path = path;
            this._taglib = taglib;
        }

        public IResource getResource() {
            return null;
        }

        public IPath getPath() {
            return this._path;
        }

        public FaceletTaglib getTaglib() {
            return this._taglib;
        }
    }
}

