/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.wizards;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.ws.internal.cxf.core.CXFClasspathContainer;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFFactory;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Version;

public class CXFInstallWizardPage
extends WizardPage {
    private IStatus CXF_LOCATION_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", null);
    private IStatus CXF_TYPE_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", null);
    private IStatus CXF_VERSION_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", null);
    private IStatus OK_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", "");
    private Pattern digitPattern = Pattern.compile("\\d");
    private Button browseButton;
    private Text cxfHomeDirText;
    private Text cxfTypeText;
    private Text cxfVersionText;
    String cxfRuntimeVersion = "";
    String cxfRuntimeLocation = "";
    String cxfRuntimeType = "";
    private CXFInstall cxfInstall;

    protected CXFInstallWizardPage() {
        super("cxf.intall.wizard.page");
        this.setTitle(CXFUIMessages.CXF_INSTALL_WIZARD_PAGE_TITLE);
        this.setDescription(CXFUIMessages.CXF_INSTALL_WIZARD_PAGE_DESCRIPTION);
        this.setImageDescriptor(CXFUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.ui", (String)"icons/wizban/library_wiz.png"));
    }

    public void createControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_CXF_HOME_DIR_LABEL);
        this.cxfHomeDirText = new Text(composite, 2048);
        gridData = new GridData(768);
        this.cxfHomeDirText.setLayoutData((Object)gridData);
        this.cxfHomeDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CXFInstallWizardPage.this.updateLocationStatus();
            }
        });
        this.browseButton = new Button(composite, 0);
        this.browseButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_BROWSE_BUTTON_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fileDialog = new DirectoryDialog(composite.getShell());
                String fileName = fileDialog.open();
                if (fileName != null) {
                    CXFInstallWizardPage.this.cxfHomeDirText.setText(fileName);
                }
            }
        });
        Label cxfVersionLabel = new Label(composite, 0);
        cxfVersionLabel.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_CXF_VERSION_LABEL);
        this.cxfVersionText = new Text(composite, 2056);
        gridData = new GridData(768);
        this.cxfVersionText.setLayoutData((Object)gridData);
        this.cxfVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CXFInstallWizardPage.this.updateVersionStatus();
            }
        });
        new Label(composite, 0);
        Label cxfTypeLabel = new Label(composite, 0);
        cxfTypeLabel.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_CXF_TYPE_LABEL);
        this.cxfTypeText = new Text(composite, 2048);
        gridData = new GridData(768);
        this.cxfTypeText.setLayoutData((Object)gridData);
        this.cxfTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CXFInstallWizardPage.this.updateTypeStatus();
            }
        });
        if (this.cxfInstall != null) {
            this.cxfHomeDirText.setText(this.cxfInstall.getLocation());
            this.cxfVersionText.setText(this.cxfInstall.getVersion());
            this.cxfTypeText.setText(this.cxfInstall.getType());
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setCXFInstall(CXFInstall cxfInstall) {
        this.cxfInstall = cxfInstall;
    }

    private void updateLocationStatus() {
        this.CXF_LOCATION_STATUS = this.checkRuntimeExist(this.cxfHomeDirText.getText());
        this.applyStatusToPage(this.findMostSevere());
    }

    private void updateTypeStatus() {
        this.CXF_TYPE_STATUS = this.validateTypeName(this.cxfTypeText.getText());
        this.applyStatusToPage(this.findMostSevere());
    }

    private void updateVersionStatus() {
        this.CXF_VERSION_STATUS = this.validateVersion(this.cxfVersionText.getText());
        this.applyStatusToPage(this.findMostSevere());
    }

    private void applyStatusToPage(IStatus status) {
        String message = status.getMessage();
        if (status.getSeverity() > 0) {
            this.setErrorMessage(message);
            this.setPageComplete(false);
        } else {
            this.setMessage(this.getDescription());
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private IStatus findMostSevere() {
        if (this.CXF_TYPE_STATUS.getSeverity() > this.CXF_LOCATION_STATUS.getSeverity()) {
            return this.CXF_TYPE_STATUS;
        }
        if (this.CXF_VERSION_STATUS.getSeverity() > this.CXF_LOCATION_STATUS.getSeverity()) {
            return this.CXF_VERSION_STATUS;
        }
        if (this.CXF_TYPE_STATUS.getSeverity() == this.CXF_LOCATION_STATUS.getSeverity()) {
            return this.CXF_LOCATION_STATUS;
        }
        if (this.CXF_VERSION_STATUS.getSeverity() == this.CXF_LOCATION_STATUS.getSeverity()) {
            return this.CXF_LOCATION_STATUS;
        }
        return this.CXF_LOCATION_STATUS;
    }

    private IStatus checkRuntimeExist(String path) {
        String[] cxfJarFiles;
        File cxfLibFolder;
        File cxfHomeDir = new File(path);
        if (this.cxfHomeDirText.getText().trim().equals("")) {
            this.CXF_LOCATION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_NOT_SET);
        }
        String cxfLibPath = cxfHomeDir + System.getProperty("file.separator") + "lib";
        if (cxfHomeDir.isDirectory() && (cxfLibFolder = new File(cxfLibPath)).isDirectory() && (cxfJarFiles = this.getCXFJarFiles(cxfLibFolder)) != null && cxfJarFiles.length > 0) {
            IStatus toolVersionStatus = this.getToolVersion(cxfLibPath);
            this.processToolVersion(toolVersionStatus);
            this.CXF_LOCATION_STATUS = this.OK_STATUS;
            return this.CXF_LOCATION_STATUS;
        }
        this.cxfTypeText.setText("");
        this.cxfVersionText.setText("");
        this.CXF_LOCATION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_NOT_SET);
        return this.CXF_LOCATION_STATUS;
    }

    private IStatus validateTypeName(String typeName) {
        this.CXF_TYPE_STATUS = typeName.trim().length() == 0 ? new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_ENTER_TYPE_NAME) : this.OK_STATUS;
        this.CXF_TYPE_STATUS = !typeName.matches("[a-zA-Z0-9_\\-\\s]+") ? new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.bind((String)CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_INVALID_TYPE_NAME, (Object)typeName)) : this.OK_STATUS;
        return this.CXF_TYPE_STATUS;
    }

    private IStatus validateVersion(String version) {
        this.CXF_VERSION_STATUS = CXFCorePlugin.getDefault().getJava2WSContext().getInstallations().containsKey(version) && this.cxfInstall != null && !this.cxfInstall.getVersion().equals(version) ? new Status(4, "org.eclipse.jst.ws.cxf.ui", "Version already installed") : this.OK_STATUS;
        return this.CXF_VERSION_STATUS;
    }

    private String[] getCXFJarFiles(File directory) {
        String[] cxfJarFiles = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("cxf") && name.endsWith(".jar") && CXFInstallWizardPage.this.digitPattern.matcher(name).find();
            }
        });
        return cxfJarFiles;
    }

    private IStatus getToolVersion(String cxLibFolderPath) {
        String[] jarFiles;
        File cxfLibFolder = new File(cxLibFolderPath);
        ArrayList<String> cxfLib = new ArrayList<String>();
        String[] stringArray = jarFiles = cxfLibFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String jarFile = stringArray[n2];
            cxfLib.add(String.valueOf(cxLibFolderPath) + System.getProperty("file.separator") + jarFile);
            ++n2;
        }
        IStatus toolVersionStatus = LaunchUtils.launch((String[])cxfLib.toArray(new String[cxfLib.size()]), (String)"org.apache.cxf.tools.wsdlto.WSDLToJava", (String[])new String[]{"-v"});
        return toolVersionStatus;
    }

    private void processToolVersion(IStatus toolVersionStatus) {
        if (toolVersionStatus.getSeverity() == 1) {
            String cxfToolVersion = toolVersionStatus.getMessage();
            Matcher matcher = this.digitPattern.matcher(cxfToolVersion = cxfToolVersion.substring(cxfToolVersion.indexOf("-") + 1, cxfToolVersion.length()).trim());
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                while (matcher.find()) {
                    end = matcher.end();
                }
                this.cxfRuntimeType = cxfToolVersion.substring(0, start).trim();
                this.cxfRuntimeVersion = cxfToolVersion.substring(start, end);
            }
            Version version = this.parseVersion(this.cxfRuntimeVersion);
            this.cxfRuntimeVersion = version.toString();
            this.cxfVersionText.setText(this.cxfRuntimeVersion);
            this.cxfTypeText.setText(this.cxfRuntimeType);
            CXFCorePlugin.getDefault().setCurrentRuntimeVersion(version);
        }
    }

    private Version parseVersion(String version) {
        if (version.trim().length() == 0) {
            return new Version(0, 0, 0);
        }
        String major = null;
        String minor = null;
        String micro = null;
        String qualifier = null;
        int segments = 0;
        int index = 0;
        while (index < version.length()) {
            block15: {
                block13: {
                    block14: {
                        if (Character.isDigit(version.charAt(index))) break block13;
                        if (version.charAt(index) != '.') break block14;
                        ++segments;
                        break block15;
                    }
                    if (major == null) {
                        major = "0";
                    }
                    if (minor == null) {
                        minor = "0";
                    }
                    if (micro == null) {
                        micro = "0";
                    }
                    if (qualifier != null) break block15;
                    qualifier = version.substring(index);
                    break block15;
                }
                if (segments == 0) {
                    major = this.findSegment(version, index);
                    index += major.length() - 1;
                } else if (segments == 1) {
                    minor = this.findSegment(version, index);
                    index += minor.length() - 1;
                } else if (segments == 2 && (index += (micro = this.findSegment(version, index)).length()) < version.length() && version.charAt(index) == '.') {
                    while (index < version.length() - 1 && version.charAt(index) == '.') {
                        ++index;
                    }
                }
            }
            if (major != null && minor != null && micro != null) {
                if (qualifier == null && index < version.length() - 1) {
                    qualifier = version.substring(index);
                }
                if (qualifier == null || qualifier.indexOf(46) == -1) break;
                qualifier = qualifier.replace('.', '_');
                break;
            }
            ++index;
        }
        return new Version(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(micro), qualifier);
    }

    private String findSegment(String version, int beginIndex) {
        int endIndex = beginIndex;
        while (endIndex < version.length() && Character.isDigit(version.charAt(endIndex))) {
            ++endIndex;
        }
        if (endIndex == beginIndex) {
            return Character.toString(version.charAt(beginIndex));
        }
        return version.substring(beginIndex, endIndex);
    }

    public boolean finish() {
        Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
        Map installs = context.getInstallations();
        CXFInstall install = CXFFactory.eINSTANCE.createCXFInstall();
        install.setVersion(this.cxfVersionText.getText().trim());
        install.setLocation(this.cxfHomeDirText.getText().trim());
        install.setType(this.cxfTypeText.getText().trim());
        installs.put(this.cxfRuntimeVersion, install);
        context.setInstallations(installs);
        if (this.isUpdateRequired(install)) {
            this.updateProjects(install);
        }
        return true;
    }

    public boolean isUpdateRequired(CXFInstall install) {
        if (this.cxfInstall == null) {
            return false;
        }
        return !this.cxfInstall.getLocation().equals(install.getLocation()) || !this.cxfInstall.getType().equals(install.getType());
    }

    public void updateProjects(CXFInstall install) {
        try {
            Set cxfProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)ProjectFacetsManager.getProjectFacet((String)"cxf.core"));
            for (IFacetedProject cxfProject : cxfProjects) {
                ClasspathContainerInitializer classpathContainerInitializer;
                String installedVersion = CXFCorePlugin.getDefault().getCXFRuntimeVersion(cxfProject.getProject());
                if (!installedVersion.equals(install.getVersion()) || (classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jst.ws.cxf.core.CXF_CLASSPATH_CONTAINER")) == null) continue;
                Path containerPath = new Path("org.eclipse.jst.ws.cxf.core.CXF_CLASSPATH_CONTAINER");
                IJavaProject javaProject = JavaCore.create((IProject)cxfProject.getProject());
                CXFClasspathContainer cxfClasspathContainer = new CXFClasspathContainer((IPath)containerPath, javaProject);
                classpathContainerInitializer.requestClasspathContainerUpdate((IPath)containerPath, javaProject, (IClasspathContainer)cxfClasspathContainer);
            }
        }
        catch (CoreException ce) {
            CXFUIPlugin.log(ce.getStatus());
        }
    }
}

