/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.eclipse.jubula.autagent.common.AutStarter;
import org.eclipse.jubula.autagent.common.desktop.DesktopIntegration;
import org.eclipse.jubula.autagent.common.utils.AutStartHelperRegister;
import org.eclipse.jubula.autagent.common.utils.IAUTStartHelper;
import org.eclipse.jubula.autagent.internal.APIAgentAutStartHelper;
import org.eclipse.jubula.autagent.internal.EmbeddedDesktopIntegration;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.MakeR;
import org.eclipse.jubula.client.exceptions.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.utils.NetUtil;

public enum Embedded {
    INSTANCE;

    private AUTAgent m_agent = null;
    private DesktopIntegration m_tray = null;

    public AUTAgent agent() throws CommunicationException {
        if (this.m_agent == null) {
            int port = NetUtil.getFreePort();
            return this.agent(port);
        }
        return this.m_agent;
    }

    public AUTAgent agent(int port) throws CommunicationException {
        if (this.m_agent == null) {
            AutStarter starter = AutStarter.getInstance();
            try {
                starter.start(port, false, AutStarter.Verbosity.QUIET, false);
                AutStartHelperRegister.INSTANCE.setAutStartHelper((IAUTStartHelper)new APIAgentAutStartHelper());
                this.m_agent = MakeR.createAUTAgent((String)"localhost", (int)port);
                this.m_tray = new EmbeddedDesktopIntegration();
                this.m_tray.setPort(port);
                starter.getAgent().addPropertyChangeListener("auts", (PropertyChangeListener)this.m_tray);
            }
            catch (IOException | JBVersionException e) {
                throw new CommunicationException(e);
            }
        }
        return this.m_agent;
    }

    public void shutdown() {
        AutStarter.shutdown();
        this.m_tray.removeSystemTray();
        this.m_agent = null;
    }
}

