/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.commands;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import org.eclipse.jubula.client.RCPKeyboardRegistry;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.communication.internal.APICommand;
import org.eclipse.jubula.communication.internal.message.GetKeyboardLayoutNameResponseMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SetKeyboardLayoutMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetKeyboardLayoutNameResponseCommand
implements APICommand {
    private static final Logger LOG = LoggerFactory.getLogger(GetKeyboardLayoutNameResponseCommand.class);
    private GetKeyboardLayoutNameResponseMessage m_message;
    private BaseConnection m_connection;

    public GetKeyboardLayoutNameResponseCommand(BaseConnection connection) {
        this.m_connection = connection;
    }

    public GetKeyboardLayoutNameResponseMessage getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (GetKeyboardLayoutNameResponseMessage)message;
    }

    /*
     * Unable to fully structure code
     */
    public Message execute() {
        block30: {
            layoutName = this.m_message.getKeyboardLayoutName();
            if (layoutName == null || layoutName.length() <= 0) break block30;
            prop = RCPKeyboardRegistry.INSTANCE.getPropertiesForLocalCode(layoutName);
            stream = null;
            try {
                if (prop != null) ** GOTO lbl17
                filename = "resources/keyboard_mapping/" + layoutName + ".properties";
                resource = this.getClass().getClassLoader().getResource(filename);
                if (resource == null) {
                    GetKeyboardLayoutNameResponseCommand.LOG.error("Mapping for '" + layoutName + "' could not be found.");
                    return null;
                }
                try {
                    stream = new InputStreamReader(resource.openStream(), Charset.forName("UTF-8"));
                    if (stream != null) {
                        prop = new Properties();
                        prop.load(stream);
                    }
lbl17:
                    // 4 sources

                    if (prop != null) {
                        this.m_connection.send((Message)new SetKeyboardLayoutMessage(prop));
                    }
                }
                catch (IOException ioe) {
                    GetKeyboardLayoutNameResponseCommand.LOG.error("Error occurred while loading Keyboard Mapping.", (Throwable)ioe);
                }
                catch (IllegalArgumentException iae) {
                    GetKeyboardLayoutNameResponseCommand.LOG.error("Error occurred while loading Keybaord Mapping.", (Throwable)iae);
                }
                catch (ConnectionException e) {
                    GetKeyboardLayoutNameResponseCommand.LOG.error("Error occurred while loading Keybaord Mapping.", (Throwable)e);
                }
                catch (CommunicationException e) {
                    GetKeyboardLayoutNameResponseCommand.LOG.error("Error occurred while loading Keybaord Mapping.", (Throwable)e);
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        GetKeyboardLayoutNameResponseCommand.LOG.warn("Error occurred while closing stream.", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + "timeout() called");
    }
}

