/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the GraphicsComponentActionHandler component from the base toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-04-15T07:16:39.313Z")
public class GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler {
            @NonNull protected IComponentIdentifier m_componentIdentifier;
            public GraphicsComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super();
                Validate.isTrue(componentIdentifier instanceof IComponentIdentifier);
                m_componentIdentifier = (IComponentIdentifier) componentIdentifier;
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param textSizeInPoints 
         *        the text size (in points)
         * @param timePerWordInMilliseconds 
         *        the time to wait per word (in milliseconds)
         * @param windowWidthInPixels 
         *        the window width in pixels
         * 
         */
        public Result showText(
            @Nullable String text,
            @Nullable Integer textSizeInPoints,
            @Nullable Integer timePerWordInMilliseconds,
            @Nullable Integer windowWidthInPixels
        )  {
            if (text == null) return null;
            
            if (textSizeInPoints == null) return null;
            
            if (timePerWordInMilliseconds == null) return null;
            
            if (windowWidthInPixels == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcShowText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(textSizeInPoints)
                            .addParameter(timePerWordInMilliseconds)
                            .addParameter(windowWidthInPixels)
                            .build(), null);
        }
        
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistence(
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * @since 4.1
         */
        public Result checkExistence(
            @Nullable Boolean exists
        )  {
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablement(
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        )  {
            if (enabled == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEnabled")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(enabled)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablement(
            @Nullable Boolean enabled
        )  {
            if (enabled == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEnabled")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(enabled)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkProperty(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkProperty(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        
        /**
         * 
         * @param hasFocus 
         *        whether focus is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkFocus(
            @Nullable Boolean hasFocus,
            @Nullable Integer timeoutInMs
        )  {
            if (hasFocus == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyFocus")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(hasFocus)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param hasFocus 
         *        whether focus is expected or not
         * @since 4.1
         */
        public Result checkFocus(
            @Nullable Boolean hasFocus
        )  {
            if (hasFocus == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyFocus")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(hasFocus)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public Result waitForComponent(
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        )  {
            if (timeoutInMs == null) return null;
            
            if (delayAfterVisibility == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWaitForComponent")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(timeoutInMs)
                            .addParameter(delayAfterVisibility)
                            .build(), null);
        }
        /**
         * 
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public Result waitForComponent(
            @Nullable Integer delayAfterVisibility
        )  {
            if (delayAfterVisibility == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWaitForComponent")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(0)
                            .addParameter(delayAfterVisibility)
                            .build(), null);
        }
        
        /**
         * 
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result click(
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        )  {
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClick")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result clickInComponent(
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickDirect")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupSelectByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable InteractionMode mouseButton
        )  {
            if (indexpath == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupSelectByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupSelectByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupSelectByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (indexpath == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        )  {
            if (indexpath == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (enabled == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyEnabledByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        )  {
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifyExistsByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (indexpath == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        )  {
            if (indexpath == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (indexpath == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(indexpath)
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer timeoutInMs
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPopupVerifySelectedByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result drag(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDrag")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result drop(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDrop")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        
        /**
         * Use this to invoke the specified method
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeMethod")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * Use this to invoke the specified method
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public Result invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeMethod")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Get the Property Value for the given Parameter
         * @param propertyName 
         *        the name of the property
         * @since 5.0
         */
        public Result getPropertyValue(
            @Nullable String propertyName
        )  {
            if (propertyName == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcGetPropertyValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .build(), null);
        }
        
} 