/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet.ui.wizards;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.libra.facet.internal.ui.LibraFacetUIPlugin;
import org.eclipse.libra.facet.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ConvertProjectsToBundlesWizardPage
extends WizardPage {
    private IObservableSet fUnconverted;
    private IObservableSet fSelected;

    public ConvertProjectsToBundlesWizardPage(IProject[] unconverted, IProject[] selected) {
        super("converToWAB");
        this.setTitle(Messages.ConvertProjectsToBundlesWizardPage_Title);
        this.setDescription(Messages.ConvertProjectsToBundlesWizardPage_Description);
        this.fUnconverted = new WritableSet(Arrays.asList(unconverted), IProject.class);
        this.fSelected = new WritableSet(Arrays.asList(selected), IProject.class);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.createProjectsViewer(container);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().margins(5, 0).numColumns(2).generateLayout(container);
        Dialog.applyDialogFont((Control)container);
    }

    public IProject[] getProjects() {
        return (IProject[])this.fSelected.toArray((Object[])new IProject[this.fSelected.size()]);
    }

    private void createProjectsViewer(Composite parent) {
        DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        Label projectsLabel = new Label(parent, 0);
        projectsLabel.setText(Messages.ConvertProjectsToBundlesWizardPage_AvailableProjects);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)projectsLabel);
        CheckboxTableViewer projectsViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2816);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(projectsViewer.getControl());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        projectsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        projectsViewer.setInput((Object)this.fUnconverted);
        projectsViewer.setComparator(new ViewerComparator());
        dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)projectsViewer, IProject.class), this.fSelected);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new SelectionValidator());
        Composite buttonGroup = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().generateLayout(buttonGroup);
        Button selectAllButton = new Button(buttonGroup, 8);
        selectAllButton.setText(Messages.ConvertProjectsToBundlesWizardPage_SelectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertProjectsToBundlesWizardPage.this.fSelected.addAll((Collection)ConvertProjectsToBundlesWizardPage.this.fUnconverted);
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)selectAllButton);
        Button deselectAllButton = new Button(buttonGroup, 8);
        deselectAllButton.setText(Messages.ConvertProjectsToBundlesWizardPage_DeselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object o : ConvertProjectsToBundlesWizardPage.this.fUnconverted) {
                    ConvertProjectsToBundlesWizardPage.this.fSelected.remove(o);
                }
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)deselectAllButton);
        Button addReferencesButton = new Button(buttonGroup, 8);
        addReferencesButton.setText(Messages.ConvertProjectsToBundlesWizardPage_AddReferences);
        addReferencesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertProjectsToBundlesWizardPage.this.selectReferences();
            }
        });
        GridDataFactory.fillDefaults().indent(0, 8).applyTo((Control)addReferencesButton);
        Label selectedCountLabel = new Label(buttonGroup, 64);
        GridDataFactory.swtDefaults().align(4, 1024).grab(false, true).applyTo((Control)selectedCountLabel);
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)selectedCountLabel), (IObservableValue)new ComputedValue(String.class){

            protected Object calculate() {
                return NLS.bind((String)Messages.ConvertProjectsToBundlesWizardPage_SelectionCounter, (Object)ConvertProjectsToBundlesWizardPage.this.fSelected.size(), (Object)ConvertProjectsToBundlesWizardPage.this.fUnconverted.size());
            }
        });
    }

    private void selectReferences() {
        IProject[] selectedProjects;
        IProject[] iProjectArray = selectedProjects = this.getProjects();
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null) {
                IVirtualReference[] references;
                IVirtualReference[] iVirtualReferenceArray = references = component.getReferences();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVirtualReference ref = iVirtualReferenceArray[n4];
                    IProject refProject = ref.getReferencedComponent().getProject();
                    try {
                        if (refProject != null && refProject != project && !OSGiBundleFacetUtils.isOSGiBundle((IProject)refProject)) {
                            this.fSelected.add((Object)refProject);
                        }
                    }
                    catch (CoreException e) {
                        LibraFacetUIPlugin.logError(e);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private class SelectionValidator
    extends MultiValidator {
        private SelectionValidator() {
        }

        protected IStatus validate() {
            if (ConvertProjectsToBundlesWizardPage.this.fSelected.size() == 0) {
                return ValidationStatus.cancel((String)ConvertProjectsToBundlesWizardPage.this.getDescription());
            }
            if (this.missingReferences()) {
                return ValidationStatus.warning((String)Messages.ConvertProjectsToBundlesWizardPage_ReferencedProjectsNotSelected);
            }
            return ValidationStatus.ok();
        }

        private boolean missingReferences() {
            IProject[] selectedProjects;
            IProject[] iProjectArray = selectedProjects = ConvertProjectsToBundlesWizardPage.this.getProjects();
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                if (component != null) {
                    IVirtualReference[] references;
                    IVirtualReference[] iVirtualReferenceArray = references = component.getReferences();
                    int n3 = references.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IVirtualReference ref = iVirtualReferenceArray[n4];
                        IProject refProject = ref.getReferencedComponent().getProject();
                        try {
                            if (refProject != null && refProject != project && !OSGiBundleFacetUtils.isOSGiBundle((IProject)refProject) && !ConvertProjectsToBundlesWizardPage.this.fSelected.contains((Object)refProject)) {
                                return true;
                            }
                        }
                        catch (CoreException e) {
                            LibraFacetUIPlugin.logError(e);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return false;
        }
    }
}

