/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.hover.FocusableBrowserInformationControl;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class LSPTextHover
implements ITextHover,
ITextHoverExtension {
    private static final String HEAD = "<head>";
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage(true));
    private IRegion lastRegion;
    private ITextViewer lastViewer;
    private CompletableFuture<List<Hover>> request;

    public static String styleHtml(String html) {
        if (html == null || html.isEmpty()) {
            return html;
        }
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.HOVER_FOREGROUND");
        Color background = colorRegistry.get("org.eclipse.ui.workbench.HOVER_BACKGROUND");
        String style = "<style TYPE='text/css'>html { font-family: " + JFaceResources.getDefaultFontDescriptor().getFontData()[0].getName() + "; " + "font-size: " + Integer.toString(JFaceResources.getDefaultFontDescriptor().getFontData()[0].getHeight()) + "pt; " + (background != null ? "background-color: " + LSPTextHover.toHTMLrgb(background.getRGB()) + "; " : "") + (foreground != null ? "color: " + LSPTextHover.toHTMLrgb(foreground.getRGB()) + "; " : "") + " }</style>";
        int headIndex = html.indexOf(HEAD);
        StringBuilder builder = new StringBuilder(html.length() + style.length());
        builder.append(html.substring(0, headIndex + HEAD.length()));
        builder.append(style);
        builder.append(html.substring(headIndex + HEAD.length()));
        return builder.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        CompletableFuture<String> hoverInfoFuture = this.getHoverInfoFuture(textViewer, hoverRegion);
        if (hoverInfoFuture != null) {
            try {
                String result = hoverInfoFuture.get(500L, TimeUnit.MILLISECONDS);
                if (result != null) {
                    return result;
                }
            }
            catch (ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    public CompletableFuture<String> getHoverInfoFuture(@NonNull ITextViewer textViewer, @NonNull IRegion hoverRegion) {
        if (this.request == null || !textViewer.equals(this.lastViewer) || !hoverRegion.equals(this.lastRegion)) {
            this.initiateHoverRequest(textViewer, hoverRegion.getOffset());
        }
        return this.request.thenApply(hoversList -> {
            String result = hoversList.stream().filter(Objects::nonNull).map(LSPTextHover::getHoverString).filter(Objects::nonNull).collect(Collectors.joining("\n\n")).trim();
            if (!result.isEmpty()) {
                return LSPTextHover.styleHtml(MARKDOWN_PARSER.parseToHtml(result));
            }
            return null;
        });
    }

    protected static @Nullable String getHoverString(@NonNull Hover hover) {
        Either hoverContent = hover.getContents();
        if (hoverContent.isLeft()) {
            List contents = (List)hoverContent.getLeft();
            if (contents == null || contents.isEmpty()) {
                return null;
            }
            return contents.stream().map(content -> {
                if (content.isLeft()) {
                    return (String)content.getLeft();
                }
                if (content.isRight()) {
                    MarkedString markedString = (MarkedString)content.getRight();
                    if (markedString.getLanguage() != null && !markedString.getLanguage().isEmpty()) {
                        return String.format("```%s%n%s%n```", markedString.getLanguage(), markedString.getValue());
                    }
                    return markedString.getValue();
                }
                return "";
            }).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.joining("\n\n"));
        }
        return ((MarkupContent)hoverContent.getRight()).getValue();
    }

    private static @NonNull String toHTMLrgb(RGB rgb) {
        StringBuilder builder = new StringBuilder(7);
        builder.append('#');
        LSPTextHover.appendAsHexString(builder, rgb.red);
        LSPTextHover.appendAsHexString(builder, rgb.green);
        LSPTextHover.appendAsHexString(builder, rgb.blue);
        return builder.toString();
    }

    private static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null) {
            return null;
        }
        if (this.request == null || this.lastRegion == null || !textViewer.equals(this.lastViewer) || offset < this.lastRegion.getOffset() || offset > this.lastRegion.getOffset() + this.lastRegion.getLength()) {
            this.initiateHoverRequest(textViewer, offset);
        }
        try {
            IDocument document = textViewer.getDocument();
            boolean[] oneHoverAtLeast = new boolean[1];
            int[] regionStartOffset = new int[1];
            int[] regionEndOffset = new int[]{document.getLength()};
            this.request.get(500L, TimeUnit.MILLISECONDS).stream().filter(Objects::nonNull).map(Hover::getRange).filter(Objects::nonNull).forEach(range -> {
                try {
                    nArray[0] = Math.max(regionStartOffset[0], LSPEclipseUtils.toOffset(range.getStart(), document));
                    nArray2[0] = Math.min(regionEndOffset[0], LSPEclipseUtils.toOffset(range.getEnd(), document));
                    blArray[0] = true;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            });
            if (oneHoverAtLeast[0]) {
                this.lastRegion = new Region(regionStartOffset[0], regionEndOffset[0] - regionStartOffset[0]);
                return this.lastRegion;
            }
        }
        catch (ExecutionException | TimeoutException e1) {
            LanguageServerPlugin.logError(e1);
        }
        catch (InterruptedException e1) {
            LanguageServerPlugin.logError(e1);
            Thread.currentThread().interrupt();
        }
        this.lastRegion = new Region(offset, 0);
        return this.lastRegion;
    }

    private void initiateHoverRequest(@NonNull ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        this.lastViewer = viewer;
        this.request = LanguageServiceAccessor.getLanguageServers(document, capabilities -> Boolean.TRUE.equals(capabilities.getHoverProvider())).thenApplyAsync(languageServers -> languageServers.stream().map(languageServer -> {
            try {
                return (Hover)languageServer.getTextDocumentService().hover(LSPEclipseUtils.toHoverParams(offset, document)).get();
            }
            catch (ExecutionException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
                return null;
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }
}

