/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameRefactoringWizard;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPRenameHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(part instanceof ITextEditor)) {
            return null;
        }
        ISelection sel = ((ITextEditor)part).getSelectionProvider().getSelection();
        if (!(sel instanceof ITextSelection) || sel.isEmpty()) {
            return null;
        }
        ITextSelection textSelection = (ITextSelection)sel;
        IDocument document = LSPEclipseUtils.getDocument((ITextEditor)part);
        if (document == null) {
            return null;
        }
        Shell shell = part.getSite().getShell();
        return LanguageServiceAccessor.getLanguageServers(document, LSPRenameHandler::isRenameProvider).thenAcceptAsync(languageServers -> {
            if (languageServers.isEmpty()) {
                return;
            }
            int offset = textSelection.getOffset();
            LSPRenameProcessor processor = new LSPRenameProcessor(document, (LanguageServer)languageServers.get(0), offset);
            ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            LSPRenameRefactoringWizard wizard = new LSPRenameRefactoringWizard((Refactoring)refactoring);
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            shell.getDisplay().asyncExec(() -> {
                try {
                    operation.run(shell, Messages.rename_title);
                }
                catch (InterruptedException e1) {
                    LanguageServerPlugin.logError(e1);
                    Thread.currentThread().interrupt();
                }
            });
        });
    }

    public static boolean isRenameProvider(ServerCapabilities serverCapabilities) {
        if (serverCapabilities == null) {
            return false;
        }
        Either renameProvider = serverCapabilities.getRenameProvider();
        if (renameProvider == null) {
            return false;
        }
        if (renameProvider.isLeft()) {
            return renameProvider.getLeft() != null && (Boolean)renameProvider.getLeft() != false;
        }
        if (renameProvider.isRight()) {
            return renameProvider.getRight() != null;
        }
        return false;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (!(part instanceof ITextEditor)) {
            return false;
        }
        ISelection selection = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection) || selection.isEmpty()) {
            return false;
        }
        if (!(part instanceof ITextEditor)) {
            return false;
        }
        IDocument document = LSPEclipseUtils.getDocument((ITextEditor)part);
        if (document == null) {
            return false;
        }
        try {
            return !LanguageServiceAccessor.getLanguageServers(document, LSPRenameHandler::isRenameProvider).get(50L, TimeUnit.MILLISECONDS).isEmpty();
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            LanguageServiceAccessor.getLanguageServers(document, LSPRenameHandler::isRenameProvider).thenAccept(languageServer -> {
                boolean enabled = !languageServer.isEmpty();
                HandlerEvent handleEvent = new HandlerEvent((IHandler)this, enabled, false);
                this.fireHandlerChanged(handleEvent);
            });
            return false;
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

