/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.xml.discoverer;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.Messages;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.xml.discoverer.internal.XmlActivator;
import org.eclipse.modisco.xml.resource.GenericXMLResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLModelDiscoverer
extends AbstractModelDiscoverer<IFile> {
    public static final String ID = "org.eclipse.modisco.xml.discoverer";
    private static final Resource.Factory XML_RESOURCE_FACTORY = new GenericXMLResourceFactoryImpl();
    private boolean ignoreWhitespace = false;
    private boolean lightweightModel = false;

    @Parameter(name="IGNORE_WHITESPACE", description="Whether to ignore whitespace in text portions.")
    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    protected boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    @Parameter(name="LIGHTWEIGHT", description="Minimize the memory use of the obtained model by ignoring comments and text portions consisting only of indentation or line delimiters.")
    public void setLightweightModel(boolean lightweightModel) {
        this.lightweightModel = lightweightModel;
    }

    protected boolean isLightweightModel() {
        return this.lightweightModel;
    }

    public boolean isApplicableTo(IFile file) {
        if (file.exists() && file.isSynchronized(0)) {
            try {
                IContentType candidateType;
                IContentType xmlContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
                if (file.getContentDescription() != null && (candidateType = file.getContentDescription().getContentType()) != null) {
                    return candidateType.isKindOf(xmlContentType);
                }
                return true;
            }
            catch (CoreException e) {
                Status warning = new Status(2, ID, "Could not test xml nature for file " + file.toString(), (Throwable)e);
                XmlActivator.getDefault().getLog().log((IStatus)warning);
            }
        }
        return false;
    }

    public void discoverElement(File file, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createFileURI((String)file.getPath().concat("_xml.xmi")));
        this.checkParameterValues();
        URI sourceURI = URI.createFileURI((String)file.getPath().toString());
        this.discoverResource(sourceURI);
        monitor.setTaskName(Messages.AbstractModelDiscoverer_savingModel);
        if (this.isTargetSerializationChosen()) {
            try {
                this.saveTargetModel();
            }
            catch (Exception e) {
                throw new DiscoveryException("Error saving discovery result model", (Throwable)e);
            }
        }
    }

    protected void basicDiscoverElement(IFile source, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)source.getFullPath().removeFileExtension().toString().concat("_xml.xmi"), (boolean)true));
        String absolutePath = source.getFullPath().toString();
        URI sourceURI = URI.createPlatformResourceURI((String)absolutePath, (boolean)true);
        this.discoverResource(sourceURI);
    }

    private void discoverResource(URI sourceURI) throws DiscoveryException {
        try {
            Resource resource = XML_RESOURCE_FACTORY.createResource(sourceURI);
            HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
            parameters.put("OPTION_IGNORE_WHITESPACE", this.isIgnoreWhitespace());
            parameters.put("OPTION_LIGHTWEIGHT_MODEL", this.isLightweightModel());
            resource.load(parameters);
            this.setTargetModel(resource);
        }
        catch (IOException e) {
            throw new DiscoveryException("An error occurred during model discovery from: " + sourceURI.toString(), (Throwable)e);
        }
    }

    protected void saveTargetModel() throws IOException {
        Resource xmlResource = this.getTargetModel();
        XMIResourceImpl xmiResource = new XMIResourceImpl();
        xmiResource.getContents().addAll((Collection)xmlResource.getContents());
        this.getResourceSet().getResources().add((Object)xmiResource);
        this.setTargetModel((Resource)xmiResource);
        super.saveTargetModel();
    }
}

