/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.ForcedExportsDelegate;
import org.eclipse.objectteams.otequinox.ActivationKind;
import org.eclipse.objectteams.otequinox.AspectBindingRequestAnswer;
import org.eclipse.objectteams.otequinox.AspectPermission;
import org.eclipse.objectteams.otequinox.IAspectRequestNegotiator;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.objectteams.Team;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

@NonNullByDefault
public class AspectPermissionManager {
    private static final String FORCED_EXPORT_DEFAULT = "forced.export.default";
    private static final String ASPECT_BINDING_DEFAULT = "aspect.binding.default";
    private static final String NEGOTIATION_DEFAULTS_FILE = "negotiationDefaults.txt";
    private static final String GRANTED_FORCED_EXPORTS_FILE = "grantedForcedExports.txt";
    private static final String DENIED_FORCED_EXPORTS_FILE = "deniedForcedExports.txt";
    private static final String GRANTED_TEAMS_FILE = "grantedTeams.txt";
    private static final String DENIED_TEAMS_FILE = "deniedTeams.txt";
    private Set<String> deniedAspects = new HashSet<String>();
    private AspectPermission defaultAspectBindingPermission = AspectPermission.GRANT;
    private AspectPermission defaultForcedExportPermission = AspectPermission.UNDEFINED;
    private List<IAspectRequestNegotiator> negotiators = new ArrayList<IAspectRequestNegotiator>();
    private Map<String, List<@NonNull String[]>> deniedForcedExportsByAspect = new HashMap<String, List<String[]>>();
    private Map<String, List<@NonNull String[]>> grantedForcedExportsByAspect = new HashMap<String, List<String[]>>();
    private Map<String, Set<String>> deniedTeamsByAspectBinding = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> grantedTeamsByAspectBinding = new HashMap<String, Set<String>>();
    private @Nullable IPath otequinoxState;
    private Bundle transformerBundle;
    private @Nullable PackageAdmin packageAdmin;
    private ForcedExportsDelegate forcedExportsDelegate;
    private boolean isWaitingForLocation = true;
    List<Runnable> obligations = new ArrayList<Runnable>();

    public AspectPermissionManager(Bundle bundle, @Nullable PackageAdmin packageAdmin) {
        this.transformerBundle = bundle;
        this.packageAdmin = packageAdmin;
        this.forcedExportsDelegate = new ForcedExportsDelegate();
    }

    public boolean isReady() {
        block6: {
            if (!this.isWaitingForLocation) {
                return true;
            }
            try {
                InternalPlatform platform = InternalPlatform.getDefault();
                Location instanceLocation = platform.getInstanceLocation();
                if (instanceLocation.isSet()) break block6;
                return false;
            }
            catch (NoClassDefFoundError ncdfe) {
                TransformerPlugin.log(2, "Optional class InternalPlatform not found, cannot access workspace location");
                this.isWaitingForLocation = false;
                return true;
            }
        }
        this.isWaitingForLocation = false;
        this.fetchAspectBindingPermssionsFromWorkspace();
        if (!this.obligations.isEmpty()) {
            for (Runnable job : this.obligations) {
                job.run();
            }
        }
        return true;
    }

    private void fetchAspectBindingPermssionsFromWorkspace() {
        try {
            IPath state;
            this.otequinoxState = state = InternalPlatform.getDefault().getStateLocation(this.transformerBundle, true);
            this.internalFetchAspectBindingPermssionsFromWorkspace(state);
        }
        catch (NoClassDefFoundError ncdfe) {
            TransformerPlugin.log(2, "Optional class InternalPlatform not found, cannot access workspace location");
            return;
        }
    }

    public void loadAspectBindingNegotiators(IExtensionRegistry extensionRegistry) {
        IConfigurationElement[] aspectBindingNegotiatorsConfigs = extensionRegistry.getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "aspectBindingNegotiators");
        int i = 0;
        while (i < aspectBindingNegotiatorsConfigs.length) {
            IConfigurationElement currentNegotiatorConfig = aspectBindingNegotiatorsConfigs[i];
            try {
                Object negotiator = currentNegotiatorConfig.createExecutableExtension("class");
                if (negotiator != null) {
                    this.negotiators.add((IAspectRequestNegotiator)negotiator);
                }
            }
            catch (CoreException e) {
                TransformerPlugin.log(e, "Failed to instantiate extension " + currentNegotiatorConfig);
            }
            ++i;
        }
    }

    public boolean isDeniedAspectPlugin(String symbolicName) {
        return this.deniedAspects.contains(symbolicName);
    }

    public boolean checkForcedExports(AspectBinding aspectBinding) {
        switch (aspectBinding.forcedExportsPermission) {
            case GRANT: {
                return true;
            }
            case DENY: {
                return false;
            }
            case UNDEFINED: {
                aspectBinding.forcedExportsPermission = this.internalCheckForcedExports(aspectBinding);
                return aspectBinding.forcedExportsPermission == AspectPermission.GRANT;
            }
        }
        return true;
    }

    private AspectPermission internalCheckForcedExports(AspectBinding aspectBinding) {
        IConfigurationElement[] forcedExports = aspectBinding.forcedExports;
        if (forcedExports.length == 0) {
            return AspectPermission.GRANT;
        }
        String aspectId = aspectBinding.aspectPlugin;
        String baseBundleId = aspectBinding.basePluginName;
        List<@NonNull String[]> deniedForcedExports = this.getConfiguredForcedExports(aspectId, AspectPermission.DENY, this.deniedForcedExportsByAspect);
        List<@NonNull String[]> grantedForcedExports = this.getConfiguredForcedExports(aspectId, AspectPermission.GRANT, this.grantedForcedExportsByAspect);
        IConfigurationElement[] iConfigurationElementArray = forcedExports;
        int n = forcedExports.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement forcedExport = iConfigurationElementArray[n2];
            String forcedExportsRequest = forcedExport.getValue();
            if (forcedExportsRequest != null) {
                String[] stringArray = forcedExportsRequest.split(",");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String singleForcedExportRequest = stringArray[n4];
                    singleForcedExportRequest = singleForcedExportRequest.trim();
                    boolean grantReported = false;
                    AspectPermission negotiatedPermission = this.defaultForcedExportPermission;
                    if (negotiatedPermission == AspectPermission.DENY) {
                        TransformerPlugin.log(4, "Default denial of forced export regarding package " + singleForcedExportRequest + " from bundle " + baseBundleId + " as requested by bundle " + aspectId + "; bundle not activated");
                        this.deniedAspects.add(aspectId);
                        return AspectPermission.DENY;
                    }
                    String[] listEntry = this.findRequestInList(baseBundleId, singleForcedExportRequest, deniedForcedExports);
                    if (listEntry != null) {
                        TransformerPlugin.log(4, "Explicit denial of forced export regarding package " + singleForcedExportRequest + " from bundle " + baseBundleId + " as requested by bundle " + aspectId + "; bundle not activated");
                        this.deniedAspects.add(aspectId);
                        return AspectPermission.DENY;
                    }
                    listEntry = this.findRequestInList(baseBundleId, singleForcedExportRequest, grantedForcedExports);
                    if (listEntry != null) {
                        TransformerPlugin.log(1, "Forced export granted for " + aspectId + ": " + singleForcedExportRequest + " (from bundle " + baseBundleId + ")");
                        grantReported = true;
                        grantedForcedExports.remove(listEntry);
                        negotiatedPermission = AspectPermission.GRANT;
                    }
                    boolean shouldPersist = false;
                    for (IAspectRequestNegotiator negotiator : this.negotiators) {
                        AspectBindingRequestAnswer answer = negotiator.checkForcedExport(aspectId, baseBundleId, singleForcedExportRequest, negotiatedPermission);
                        if (answer.permission.compareTo(negotiatedPermission) <= 0) continue;
                        shouldPersist = answer.persistent;
                        negotiatedPermission = answer.permission;
                        if (answer.allRequests) {
                            this.defaultForcedExportPermission = negotiatedPermission;
                        }
                        if (negotiatedPermission == AspectPermission.DENY) break;
                    }
                    if (shouldPersist && negotiatedPermission != AspectPermission.UNDEFINED) {
                        this.persistForcedExportsAnswer(aspectId, baseBundleId, singleForcedExportRequest, negotiatedPermission);
                    }
                    if (negotiatedPermission == AspectPermission.GRANT) {
                        if (!grantReported) {
                            TransformerPlugin.log(1, "Negotiation granted forced export for " + aspectId + ": " + singleForcedExportRequest + " (from bundle " + baseBundleId + ')');
                        }
                    } else {
                        String verb = "did not grant";
                        if (negotiatedPermission == AspectPermission.DENY) {
                            verb = "denied";
                        }
                        TransformerPlugin.log(4, "Negotiation " + verb + " forced export for " + aspectId + ": " + singleForcedExportRequest + " (from bundle " + baseBundleId + ")" + ". Aspect is not activated.");
                        this.deniedAspects.add(aspectId);
                        return AspectPermission.DENY;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!grantedForcedExports.isEmpty()) {
            this.reportUnmatchForcedExports(aspectId, grantedForcedExports);
        }
        return AspectPermission.GRANT;
    }

    private List<@NonNull String[]> getConfiguredForcedExports(String aspectId, AspectPermission perm, Map<String, List<@NonNull String[]>> map) {
        List<@NonNull String[]> forcedExports = map.get(aspectId);
        if (forcedExports == null) {
            forcedExports = this.forcedExportsDelegate.getForcedExportsByAspect(aspectId, perm);
            map.put(aspectId, forcedExports);
        }
        return forcedExports;
    }

    private String @Nullable [] findRequestInList(String baseBundleId, String basePackage, List<String[]> list) {
        for (String[] singleExport : list) {
            if (!singleExport[0].equals(baseBundleId) || !singleExport[1].equals(basePackage)) continue;
            return singleExport;
        }
        return null;
    }

    void reportUnmatchForcedExports(String aspectId, List<@NonNull String[]> unmatchedForcedExports) {
        for (String[] export : unmatchedForcedExports) {
            String baseId = export[0];
            String pack = export[1];
            TransformerPlugin.log(2, "Aspect " + aspectId + " does not declare forced export of package " + pack + " from bundle " + baseId + " as declared in config.ini (or system property)");
        }
    }

    private void persistForcedExportsAnswer(String aspectId, String baseBundleId, String basePackage, AspectPermission negotiatedPermission) {
        IPath state = this.otequinoxState;
        if (state == null) {
            TransformerPlugin.log(4, "Can't persist forcedExports permission, no workspace location accessable.");
            return;
        }
        try {
            String fileName = negotiatedPermission == AspectPermission.DENY ? DENIED_FORCED_EXPORTS_FILE : GRANTED_FORCED_EXPORTS_FILE;
            IPath forcedExportsPath = state.append(fileName);
            File forcedExportsFile = new File(forcedExportsPath.toOSString());
            if (!forcedExportsFile.exists()) {
                forcedExportsFile.createNewFile();
            }
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileWriter writer = new FileWriter(forcedExportsFile, true);){
                writer.append('\n');
                writer.append(baseBundleId);
                writer.append("\n[\n\t");
                writer.append(basePackage);
                writer.append(";x-friends:=\"");
                writer.append(aspectId);
                writer.append("\"\n]\n");
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            TransformerPlugin.log(ioe, "Failed to persist negotiation result");
        }
    }

    Set<@NonNull AspectBinding.TeamBinding> checkAspectPermissionDenial(Collection<AspectBinding.TeamBinding> teamsForBase) {
        HashSet<AspectBinding.TeamBinding> deniedTeams = new HashSet<AspectBinding.TeamBinding>();
        for (AspectBinding.TeamBinding teamForBase : teamsForBase) {
            AspectBinding aspectBinding = teamForBase.getAspectBinding();
            String aspectBundleName = aspectBinding.aspectPlugin;
            if (aspectBinding.hasBeenDenied) {
                deniedTeams.add(teamForBase);
                continue;
            }
            if (!this.checkForcedExports(aspectBinding)) {
                deniedTeams.add(teamForBase);
                this.stopAspectBundle(aspectBinding, aspectBundleName, "requests unconfirmed forced export(s).");
                continue;
            }
            if (this.checkTeamBinding(aspectBundleName, aspectBinding.basePluginName, teamForBase)) continue;
            deniedTeams.add(teamForBase);
            this.stopAspectBundle(aspectBinding, aspectBundleName, "requests unconfirmed aspect binding(s).");
        }
        return deniedTeams;
    }

    void stopAspectBundle(AspectBinding aspectBinding, String aspectBundleName, String reason) {
        try {
            aspectBinding.hasBeenDenied = true;
            Bundle aspectBundle = aspectBinding.aspectBundle;
            if (aspectBundle != null) {
                aspectBundle.stop();
                TransformerPlugin.log(4, "Stopped bundle " + aspectBundleName + " which " + reason);
            } else {
                TransformerPlugin.log(4, "Cannot stop aspect bundle " + aspectBundleName);
            }
        }
        catch (Throwable t) {
            TransformerPlugin.log(t, "Failed to stop bundle " + aspectBundleName + " which " + reason);
        }
    }

    boolean checkTeamBinding(String aspectBundleId, String baseBundleId, AspectBinding.TeamBinding teamBinding) {
        if (teamBinding.checkedPermission != null) {
            return teamBinding.checkedPermission == AspectPermission.GRANT;
        }
        boolean isGranted = this.internalCheckTeamBinding(aspectBundleId, baseBundleId, teamBinding.teamName);
        teamBinding.checkedPermission = isGranted ? AspectPermission.GRANT : AspectPermission.DENY;
        return isGranted;
    }

    boolean internalCheckTeamBinding(String aspectBundleId, String baseBundleId, String teamClass) {
        boolean shouldReportGrant = false;
        AspectPermission negotiatedPermission = this.defaultAspectBindingPermission;
        if (negotiatedPermission == AspectPermission.DENY) {
            TransformerPlugin.log(4, "Default denial of aspect binding regarding base bundle " + baseBundleId + " as requested by bundle " + aspectBundleId + "; bundle not activated");
            this.deniedAspects.add(aspectBundleId);
            return false;
        }
        String key = String.valueOf(aspectBundleId) + "->" + baseBundleId;
        Set<String> deniedTeams = this.deniedTeamsByAspectBinding.get(key);
        if (deniedTeams != null && !deniedTeams.isEmpty() && deniedTeams.contains(teamClass)) {
            TransformerPlugin.log(4, "Configured denial of aspect binding regarding base bundle " + baseBundleId + " as requested by bundle " + aspectBundleId + "; bundle not activated");
            this.deniedAspects.add(aspectBundleId);
            return false;
        }
        Set<String> grantedTeams = this.grantedTeamsByAspectBinding.get(key);
        if (grantedTeams != null && grantedTeams.contains(teamClass)) {
            negotiatedPermission = AspectPermission.GRANT;
            shouldReportGrant = true;
        }
        boolean shouldPersist = false;
        String denyingNegotiator = null;
        for (IAspectRequestNegotiator negotiator : this.negotiators) {
            AspectBindingRequestAnswer answer = negotiator.checkAspectBinding(aspectBundleId, baseBundleId, teamClass, negotiatedPermission);
            if (answer.permission.compareTo(negotiatedPermission) <= 0) continue;
            shouldPersist = answer.persistent;
            negotiatedPermission = answer.permission;
            boolean bl = shouldReportGrant = negotiatedPermission == AspectPermission.GRANT;
            if (answer.allRequests) {
                this.defaultAspectBindingPermission = negotiatedPermission;
            }
            if (negotiatedPermission != AspectPermission.DENY) continue;
            denyingNegotiator = negotiator.getClass().getName();
            break;
        }
        if (shouldPersist && negotiatedPermission != AspectPermission.UNDEFINED) {
            this.persistTeamBindingAnswer(aspectBundleId, baseBundleId, teamClass, negotiatedPermission);
        }
        if (negotiatedPermission == AspectPermission.GRANT) {
            if (shouldReportGrant) {
                TransformerPlugin.log(1, "Negotiation granted aspect binding for " + aspectBundleId + " to base bundle " + baseBundleId + " by means of team " + teamClass + '.');
            }
        } else {
            String front = negotiatedPermission == AspectPermission.DENY ? "Negotiator " + denyingNegotiator + " denied" : "Negotiation did not grant";
            TransformerPlugin.log(4, String.valueOf(front) + " aspect binding for " + aspectBundleId + " to base bundle " + baseBundleId + " by means of team " + teamClass + ". Aspect is not activated.");
            this.deniedAspects.add(aspectBundleId);
            return false;
        }
        return true;
    }

    public void addBaseBundleObligations(final List<Team> teamInstances, final Collection<AspectBinding.TeamBinding> teamClasses, final AspectBinding.BaseBundle baseBundle) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                ArrayList<AspectBinding.TeamBinding> teamsToRevert = new ArrayList<AspectBinding.TeamBinding>();
                for (AspectBinding.TeamBinding teamClass : teamClasses) {
                    if (AspectPermissionManager.this.checkTeamBinding(teamClass.getAspectBinding().aspectPlugin, baseBundle.bundleName, teamClass)) continue;
                    teamsToRevert.add(teamClass);
                }
                if (!teamsToRevert.isEmpty()) {
                    this.revert(teamsToRevert);
                }
            }

            void revert(List<AspectBinding.TeamBinding> teamsToRevert) {
                try {
                    HashSet<Bundle> bundlesToStop = new HashSet<Bundle>();
                    for (AspectBinding.TeamBinding teamClass : teamClasses) {
                        Bundle aspectBundle;
                        if (teamClass.getActivation() != ActivationKind.NONE) {
                            for (Team teamInstance : teamInstances) {
                                if (teamInstance.getClass() != teamClass.teamClass) continue;
                                teamInstance.deactivate(Team.ALL_THREADS);
                            }
                        }
                        if ((aspectBundle = teamClass.getAspectBinding().aspectBundle) == null) continue;
                        bundlesToStop.add(aspectBundle);
                    }
                    for (Bundle bundle : bundlesToStop) {
                        if ((bundle.getState() & 0x28) == 0) continue;
                        TransformerPlugin.log(4, "Stopping aspect bundle " + bundle.getSymbolicName() + " with denied aspect binding(s)");
                        bundle.stop();
                    }
                }
                catch (Exception e) {
                    TransformerPlugin.log(e, "Failed to revert aspect bundle with denied aspect bindings.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable job) {
        if (this.isReady()) {
            job.run();
        } else {
            List<Runnable> list = this.obligations;
            synchronized (list) {
                this.obligations.add(job);
            }
        }
    }

    void stopIllegalBundle(String symbolicName) {
        String msgCore = "stop bundle " + symbolicName + " whose requests for forced exports have been denied";
        PackageAdmin packAdmin = this.packageAdmin;
        if (packAdmin == null) {
            TransformerPlugin.log(4, "Needing to " + msgCore + " but package admin is not available");
        } else {
            Bundle[] bundles = packAdmin.getBundles(symbolicName, null);
            if (bundles == null) {
                TransformerPlugin.log(4, "Needing to " + msgCore + " but bundle cannot be retrieved");
            } else {
                try {
                    bundles[0].stop();
                }
                catch (BundleException e) {
                    TransformerPlugin.log(e, "Failed to " + msgCore);
                }
            }
        }
    }

    private void internalFetchAspectBindingPermssionsFromWorkspace(IPath state) {
        File configFile;
        IPath configFilePath;
        block26: {
            configFilePath = state.append(NEGOTIATION_DEFAULTS_FILE);
            configFile = new File(configFilePath.toOSString());
            if (configFile.exists()) {
                Properties props = new Properties();
                try {
                    Throwable throwable = null;
                    Object var6_10 = null;
                    try (FileInputStream inStream = new FileInputStream(configFile);){
                        props.load(inStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    String value = (String)props.get(ASPECT_BINDING_DEFAULT);
                    if (value != null) {
                        try {
                            this.defaultAspectBindingPermission = AspectPermission.valueOf(value);
                        }
                        catch (IllegalArgumentException iae) {
                            this.defaultAspectBindingPermission = AspectPermission.DENY;
                            TransformerPlugin.log(iae, "Cannot set default aspect permission from file negotiationDefaults.txt, assuming DENY.");
                        }
                    }
                    if ((value = (String)props.get(FORCED_EXPORT_DEFAULT)) == null) break block26;
                    try {
                        this.defaultForcedExportPermission = AspectPermission.valueOf(value);
                    }
                    catch (IllegalArgumentException iae) {
                        this.defaultForcedExportPermission = AspectPermission.DENY;
                        TransformerPlugin.log(iae, "Cannot set default forced exports permission from file negotiationDefaults.txt, assuming DENY.");
                    }
                }
                catch (IOException ioex) {
                    TransformerPlugin.log(ioex, "Failed to read configuration file " + configFilePath.toOSString());
                }
            } else {
                try {
                    File stateDir = new File(state.toOSString());
                    if (!stateDir.exists()) {
                        stateDir.mkdirs();
                    }
                    configFile.createNewFile();
                    this.writeNegotiationDefaults(configFile);
                }
                catch (IOException ioex) {
                    TransformerPlugin.log(ioex, "Failed to create configuration file " + configFilePath.toOSString());
                }
            }
        }
        if ((configFile = new File((configFilePath = state.append(GRANTED_TEAMS_FILE)).toOSString())).exists()) {
            this.parseTeamPermissionFile(this.grantedTeamsByAspectBinding, configFile);
        }
        if ((configFile = new File((configFilePath = state.append(DENIED_TEAMS_FILE)).toOSString())).exists()) {
            this.parseTeamPermissionFile(this.deniedTeamsByAspectBinding, configFile);
        }
        if ((configFile = new File((configFilePath = state.append(DENIED_FORCED_EXPORTS_FILE)).toOSString())).exists()) {
            this.forcedExportsDelegate.parseForcedExportsFile(configFile, AspectPermission.DENY);
        }
        if ((configFile = new File((configFilePath = state.append(GRANTED_FORCED_EXPORTS_FILE)).toOSString())).exists()) {
            this.forcedExportsDelegate.parseForcedExportsFile(configFile, AspectPermission.GRANT);
        }
    }

    private void writeNegotiationDefaults(File configFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(configFile);){
            writer.append("aspect.binding.default=" + this.defaultAspectBindingPermission.toString() + '\n');
            writer.append("forced.export.default=" + this.defaultForcedExportPermission.toString() + '\n');
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TransformerPlugin.log(1, "Created aspect binding defaults file " + configFile.getCanonicalPath());
    }

    private void parseTeamPermissionFile(Map<String, Set<String>> teamsByAspectBinding, File configFile) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.length() > 0 && line.charAt(0) == '#' || (parts = line.split("=")).length != 2) continue;
                    HashSet<String> teams = new HashSet<String>();
                    StringTokenizer teamToks = new StringTokenizer(parts[1], ",");
                    while (teamToks.hasMoreElements()) {
                        teams.add(teamToks.nextToken());
                    }
                    teamsByAspectBinding.put(parts[0], teams);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            TransformerPlugin.log(e, "Failed to read permission file " + configFile.getAbsolutePath());
        }
    }

    private void persistTeamBindingAnswer(String aspectBundleId, String baseBundleId, String teamClass, AspectPermission negotiatedPermission) {
        IPath state = this.otequinoxState;
        if (state != null) {
            Map<String, Set<String>> teamsByAspect = null;
            IPath configFilePath = null;
            switch (negotiatedPermission) {
                case GRANT: {
                    teamsByAspect = this.grantedTeamsByAspectBinding;
                    configFilePath = state.append(GRANTED_TEAMS_FILE);
                    break;
                }
                case DENY: {
                    teamsByAspect = this.deniedTeamsByAspectBinding;
                    configFilePath = state.append(DENIED_TEAMS_FILE);
                    break;
                }
                default: {
                    return;
                }
            }
            String key = String.valueOf(aspectBundleId) + "->" + baseBundleId;
            Set<String> teams = teamsByAspect.get(key);
            if (teams == null) {
                teams = new HashSet<String>();
                teamsByAspect.put(key, teams);
            }
            teams.add(teamClass);
            File configFile = new File(configFilePath.toOSString());
            try {
                if (!configFile.exists()) {
                    configFile.createNewFile();
                }
                Throwable throwable = null;
                Object var12_14 = null;
                try (FileWriter writer = new FileWriter(configFile, false);){
                    writer.write("# Aspect permission file generated from aspect negotiation results.\n");
                    for (Map.Entry<String, Set<String>> entry : teamsByAspect.entrySet()) {
                        writer.append(entry.getKey()).append('=');
                        String sep = "";
                        for (String t : entry.getValue()) {
                            writer.append(sep).append(t);
                            sep = ",";
                        }
                        writer.append('\n');
                    }
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                TransformerPlugin.log(ioe, "Failed to persist negotiation result");
            }
        }
    }
}

