/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.runtime.IBinding;

public class Binding
implements Comparable<Binding>,
IBinding {
    public static final int BEFORE = 1;
    public static final int REPLACE = 2;
    public static final int AFTER = 3;
    AbstractBoundClass teamClass;
    private String callinLabel;
    private String boundClass;
    private String memberName;
    private String memberSignature;
    private String weavableBaseClassName;
    private int callinModifier;
    private int perTeamId;
    private int baseFlags;
    private IBinding.BindingType type;
    private boolean isHandleCovariantReturn;
    private boolean requireBaseSuperCall;

    public IBinding.BindingType getType() {
        return this.type;
    }

    public Binding(AbstractBoundClass teamClass, String roleClassName, String callinLabel, String boundClassName, String memberName, String memberSignature, String weavableBaseClassName, int callinModifier, int callinId, int baseFlags, boolean handleCovariantReturn, boolean requireBaseSuperCall) {
        this.teamClass = teamClass;
        this.callinLabel = callinLabel;
        this.boundClass = boundClassName;
        this.memberName = memberName;
        this.memberSignature = memberSignature;
        this.weavableBaseClassName = weavableBaseClassName;
        this.callinModifier = callinModifier;
        this.perTeamId = callinId;
        this.baseFlags = baseFlags;
        this.type = IBinding.BindingType.CALLIN_BINDING;
        this.isHandleCovariantReturn = handleCovariantReturn;
        this.requireBaseSuperCall = requireBaseSuperCall;
    }

    public Binding(AbstractBoundClass teamClass, String boundClassName, String memberName, String memberSignature, int perTeamAccessId, IBinding.BindingType type) {
        this.teamClass = teamClass;
        this.boundClass = boundClassName;
        this.memberName = memberName;
        this.memberSignature = memberSignature;
        this.perTeamId = perTeamAccessId;
        this.type = type;
    }

    public Binding(AbstractBoundClass teamClass, String baseClassName) {
        this.teamClass = teamClass;
        this.boundClass = baseClassName;
        this.type = IBinding.BindingType.ROLE_BASE_BINDING;
    }

    public String getBoundClass() {
        return this.boundClass;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberSignature() {
        return this.memberSignature;
    }

    public int getBaseFlags() {
        return this.baseFlags;
    }

    public int getPerTeamId() {
        return this.perTeamId;
    }

    public boolean isHandleCovariantReturn() {
        return this.isHandleCovariantReturn;
    }

    public boolean requiresBaseSuperCall() {
        return this.requireBaseSuperCall;
    }

    public String getDeclaringBaseClassName() {
        return this.weavableBaseClassName;
    }

    public boolean equals(Object obj) {
        Binding other = (Binding)obj;
        return this.boundClass.equals(other.boundClass) && this.memberName.equals(other.memberName) && this.memberSignature.equals(other.memberSignature) && this.type == other.type && this.perTeamId == other.perTeamId;
    }

    @Override
    public int compareTo(Binding other) {
        int compare = 0;
        if (this.callinLabel == null || other.callinLabel == null) {
            if (this.callinLabel != null) {
                return 1;
            }
            if (other.callinLabel != null) {
                return -1;
            }
        } else {
            if (this.callinModifier != other.callinModifier) {
                if (this.callinModifier == 2) {
                    return -1;
                }
                if (other.callinModifier == 2) {
                    return 1;
                }
            }
            if ((compare = this.teamClass.compare(this.callinLabel, other.callinLabel)) != 0) {
                return compare;
            }
        }
        if (this.baseFlags != other.baseFlags) {
            return Integer.valueOf(this.baseFlags).compareTo(other.baseFlags);
        }
        return (String.valueOf(this.boundClass) + this.memberName + this.memberSignature).compareTo(String.valueOf(other.boundClass) + other.memberName + other.memberSignature);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.type) {
            case CALLIN_BINDING: {
                buf.append("callin: ");
                break;
            }
            case METHOD_ACCESS: {
                buf.append("callout: ");
                break;
            }
            case FIELD_ACCESS: {
                buf.append("callout-to-field: ");
                break;
            }
            case ROLE_BASE_BINDING: {
                buf.append("playedBy: ").append(this.boundClass);
                return buf.toString();
            }
        }
        buf.append('{');
        buf.append(this.perTeamId);
        buf.append("} ");
        buf.append(this.boundClass);
        buf.append('.');
        buf.append(this.memberName);
        buf.append(this.memberSignature);
        return buf.toString();
    }
}

