/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.as2es;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.uml.internal.as2es.AS2UMLDeclarationVisitor;
import org.eclipse.ocl.pivot.uml.internal.as2es.AS2UMLReferenceVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class AS2UML
extends AbstractConversion {
    private Map<Element, EModelElement> createMap = new HashMap<Element, EModelElement>();
    Set<Element> deferMap = new HashSet<Element>();
    private List<Resource.Diagnostic> errors = null;
    protected final AS2UMLDeclarationVisitor pass1 = new AS2UMLDeclarationVisitor(this);
    protected final AS2UMLReferenceVisitor pass2 = new AS2UMLReferenceVisitor(this);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull EObject> createResource(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource asResource) {
        @NonNull EList pivotModels = ClassUtil.nullFree((EList)asResource.getContents());
        AS2UML converter = new AS2UML(environmentFactory);
        return converter.convertAll((List<? extends EObject>)pivotModels);
    }

    public AS2UML(@NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
    }

    protected @Nullable EObject convert(@NonNull Element pivotObject) {
        EObject eObject = (EObject)this.pass1.safeVisit((Visitable)pivotObject);
        for (Element eKey : this.deferMap) {
            this.pass2.safeVisit((Visitable)eKey);
        }
        return eObject;
    }

    protected @NonNull List<@NonNull EObject> convertAll(@NonNull List<? extends EObject> pivotObjects) {
        ArrayList<@NonNull EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : pivotObjects) {
            EModelElement convertedEObject;
            if (!(eObject instanceof Element) || (convertedEObject = (EModelElement)this.pass1.safeVisit((Visitable)eObject)) == null) continue;
            eObjects.add((EObject)convertedEObject);
        }
        for (Element element : this.deferMap) {
            this.pass2.safeVisit((Visitable)element);
        }
        return eObjects;
    }

    protected void error(@NonNull String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public void defer(@NonNull Element pivotElement) {
        this.deferMap.add(pivotElement);
    }

    public <T extends EObject> @Nullable T getCreated(@NonNull Class<T> requiredClass, @NonNull Element pivotElement) {
        EModelElement eModelElement = this.createMap.get(pivotElement);
        if (eModelElement == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(eModelElement.getClass())) {
            throw new ClassCastException(String.valueOf(eModelElement.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        EModelElement castElement = eModelElement;
        return (T)castElement;
    }

    public void putCreated(@NonNull Element pivotElement, @NonNull EModelElement eModelElement) {
        EModelElement old = this.createMap.put(pivotElement, eModelElement);
        assert (old == null);
    }
}

