/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2ASUtil;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLOCLEValidator
implements EValidator {
    public static final @NonNull UMLOCLEValidator INSTANCE = new UMLOCLEValidator(true);
    public static final @NonNull UMLOCLEValidator NO_NEW_LINES = new UMLOCLEValidator(false);
    public static final @NonNull TracingOption VALIDATE_INSTANCE = new TracingOption("org.eclipse.ocl.pivot", "validate/instance");
    public static final @NonNull TracingOption VALIDATE_OPAQUE_ELEMENT = new TracingOption("org.eclipse.ocl.pivot", "validate/opaqueElement");
    protected final boolean mayUseNewLines;

    protected static void gatherClassifiers(@NonNull Set<Classifier> allClassifiers, @NonNull Set<org.eclipse.uml2.uml.Constraint> allConstraints, @NonNull Classifier newClassifier) {
        if (allClassifiers.add(newClassifier)) {
            EList ownedRules = newClassifier.getOwnedRules();
            assert (ownedRules != null);
            allConstraints.addAll((Collection<org.eclipse.uml2.uml.Constraint>)ownedRules);
            if (newClassifier instanceof org.eclipse.uml2.uml.Class) {
                for (Classifier classifier : ((org.eclipse.uml2.uml.Class)newClassifier).getSuperClasses()) {
                    if (classifier == null) continue;
                    UMLOCLEValidator.gatherClassifiers(allClassifiers, allConstraints, classifier);
                }
            }
        }
    }

    @Deprecated
    protected static void gatherTypes(@NonNull Set<Type> allTypes, @NonNull Set<Constraint> allConstraints, @NonNull Class newType) {
        if (allTypes.add((Type)newType)) {
            allConstraints.addAll(newType.getOwnedInvariants());
            for (Class superType : newType.getSuperClasses()) {
                if (superType == null) continue;
                UMLOCLEValidator.gatherTypes(allTypes, allConstraints, superType);
            }
        }
    }

    public UMLOCLEValidator(boolean mayUseNewLines) {
        this.mayUseNewLines = mayUseNewLines;
    }

    private void propagateProblems(@NonNull DiagnosticChain diagnostics, @NonNull Resource asResource, @Nullable EObject umlElement) {
        if (!(diagnostics instanceof Diagnostic)) {
            return;
        }
        for (Diagnostic childDiagnostic : ((Diagnostic)diagnostics).getChildren()) {
            if (!(childDiagnostic instanceof ASResourceProblems) || ((ASResourceProblems)childDiagnostic).getASResource() != asResource) continue;
            return;
        }
        diagnostics.add((Diagnostic)new ASResourceProblems(asResource, umlElement));
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (context != null);
        boolean allOk = true;
        if (eObject instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)eObject;
            @NonNull EList languages = opaqueExpression.getLanguages();
            @NonNull EList bodies = opaqueExpression.getBodies();
            allOk = this.validateOpaqueElement((List<String>)languages, (List<String>)bodies, (Element)opaqueExpression, diagnostics, context);
        } else if (eObject instanceof InstanceSpecification) {
            allOk = this.validateInstanceSpecification((InstanceSpecification)eObject, diagnostics, context);
        }
        try {
            if (eObject instanceof Element) {
                Resource umlResource;
                EList umlStereotypeApplications = ((Element)eObject).getStereotypeApplications();
                if (umlStereotypeApplications.size() > 0 && (umlResource = ((EObject)umlStereotypeApplications.get(0)).eClass().eResource()) != null) {
                    Object external2as;
                    EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)PivotUtilInternal.findEnvironmentFactory((Resource)umlResource);
                    if (environmentFactory == null) {
                        OCL ocl = PivotDiagnostician.getOCL(context, (EObject)eObject);
                        environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
                    }
                    if ((external2as = UML2AS.findAdapter((Resource)umlResource, (EnvironmentFactoryInternal)environmentFactory)) == null) {
                        external2as = UML2AS.getAdapter(umlResource, (EnvironmentFactoryInternal)environmentFactory);
                    }
                    external2as.getASModel();
                    Map<EObject, @NonNull List<Element>> umlStereotypeApplication2umlStereotypedElements = UML2ASUtil.computeAppliedStereotypes((Iterable<EObject>)umlStereotypeApplications);
                    for (EObject umlStereotypeApplication : umlStereotypeApplications) {
                        List<Element> umlStereotypedElements = umlStereotypeApplication2umlStereotypedElements.get(umlStereotypeApplication);
                        assert (umlStereotypedElements != null);
                        Stereotype stereotype = null;
                        if (external2as instanceof UML2AS) {
                            stereotype = ((UML2AS)((Object)external2as)).resolveStereotype(umlStereotypeApplication, umlStereotypedElements);
                        } else {
                            ClassUtil.nonNullState((Object)external2as.getASModel());
                            EClass umlStereotypeEClass = umlStereotypeApplication.eClass();
                            if (!(umlStereotypeApplication instanceof DynamicEObjectImpl)) {
                                stereotype = (Stereotype)((AbstractConversion)external2as).getEnvironmentFactory().getMetamodelManager().getASOfEcore(Stereotype.class, (EObject)umlStereotypeEClass);
                            }
                        }
                        if (stereotype == null) continue;
                        HashSet allConstraints = new HashSet();
                        CompleteClassInternal completeStereotype = environmentFactory.getCompleteModel().getCompleteClass((Type)stereotype);
                        for (CompleteClass completeClass : completeStereotype.getSuperCompleteClasses()) {
                            for (Class partialClass : completeClass.getPartialClasses()) {
                                allConstraints.addAll(partialClass.getOwnedInvariants());
                            }
                        }
                        for (Constraint constraint : allConstraints) {
                            LanguageExpression specification = constraint.getOwnedSpecification();
                            if (specification == null) continue;
                            try {
                                ExpressionInOCL query = environmentFactory.parseSpecification(specification);
                                EvaluationVisitor evaluationVisitor = environmentFactory.createEvaluationVisitor((Object)umlStereotypeApplication, query, null);
                                AbstractConstraintEvaluator constraintEvaluator = diagnostics != null ? new ConstraintEvaluatorWithDiagnostics(query, umlStereotypeApplication, diagnostics, eObject, this.mayUseNewLines) : new ConstraintEvaluatorWithoutDiagnostics(query);
                                if (((Boolean)constraintEvaluator.evaluate(evaluationVisitor)).booleanValue()) continue;
                                allOk = false;
                            }
                            catch (ParserException e) {
                                if (diagnostics != null) {
                                    String message = String.valueOf(StringUtil.bind((String)PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, (Object[])new Object[]{constraint.getContext().getName(), constraint.getName(), NameUtil.qualifiedNameFor((Object)eObject)})) + "\n - " + e.toString();
                                    if (!this.mayUseNewLines) {
                                        message = message.replace("\n", "");
                                    }
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity((EnvironmentFactory)environmentFactory), "org.eclipse.uml2.uml", 0, message, new Object[]{eObject}));
                                    continue;
                                }
                                allOk = false;
                            }
                        }
                    }
                }
                return allOk;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected boolean validateInstance(@NonNull EObject instanceSpecification, @NonNull OpaqueExpression opaqueExpression, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (context != null) {
            EList bodies = opaqueExpression.getBodies();
            EList languages = opaqueExpression.getLanguages();
            int i = 0;
            while (i < bodies.size()) {
                try {
                    String body;
                    String language;
                    String string = language = i < languages.size() ? (String)languages.get(i) : "OCL";
                    if ((i >= languages.size() || "OCL".equals(languages.get(i))) && (body = (String)bodies.get(i)) != null) {
                        if (VALIDATE_INSTANCE.isActive()) {
                            VALIDATE_INSTANCE.println(String.valueOf(language) + ": " + body);
                        }
                        if (!this.validateSyntax2(instanceSpecification, body, (Element)opaqueExpression, diagnostics, context) && diagnostics == null) {
                            allOk = false;
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    if (diagnostics != null) {
                        String objectLabel = EObjectValidator.getObjectLabel((EObject)opaqueExpression, context);
                        String message = NLS.bind((String)"Body processing error {0} on {1}", (Object)e, (Object)objectLabel);
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueExpression}));
                    }
                    allOk = false;
                }
                ++i;
            }
        }
        return allOk;
    }

    public boolean validateInstanceSpecification(@NonNull InstanceSpecification instanceSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object object;
        Boolean validationEnabled = null;
        InstanceSpecification umlInstanceSpecification = instanceSpecification;
        org.eclipse.uml2.uml.Stereotype validationStereotype = umlInstanceSpecification.getAppliedStereotype("OCLforUML::Validation");
        if (validationStereotype != null && (object = umlInstanceSpecification.getValue(validationStereotype, "validate")) instanceof Boolean) {
            validationEnabled = (Boolean)object;
        }
        if (validationEnabled == null) {
            InstanceSpecification eContainer = instanceSpecification;
            while ((eContainer = eContainer.eContainer()) != null) {
                Object object2;
                Package umlPackage;
                org.eclipse.uml2.uml.Stereotype validationsStereotype;
                if (!(eContainer instanceof Package) || (validationsStereotype = (umlPackage = (Package)eContainer).getAppliedStereotype("OCLforUML::Validations")) == null || !((object2 = umlPackage.getValue(validationsStereotype, "validateInstanceSpecifications")) instanceof Boolean)) continue;
                validationEnabled = (Boolean)object2;
                break;
            }
        }
        boolean allOk = true;
        if (validationEnabled == Boolean.TRUE) {
            HashSet<Classifier> allClassifiers = new HashSet<Classifier>();
            HashSet<org.eclipse.uml2.uml.Constraint> allConstraints = new HashSet<org.eclipse.uml2.uml.Constraint>();
            for (Classifier classifier : instanceSpecification.getClassifiers()) {
                if (classifier == null) continue;
                UMLOCLEValidator.gatherClassifiers(allClassifiers, allConstraints, classifier);
            }
            for (org.eclipse.uml2.uml.Constraint constraint : allConstraints) {
                OpaqueExpression opaqueExpression;
                ValueSpecification specification = constraint.getSpecification();
                if (!(specification instanceof OpaqueExpression) || this.validateInstance((EObject)instanceSpecification, opaqueExpression = (OpaqueExpression)specification, diagnostics, context) || diagnostics != null) continue;
                allOk = false;
            }
        }
        return allOk;
    }

    public boolean validateOpaqueAction(@NonNull OpaqueAction opaqueAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return INSTANCE.validateOpaqueElement((List<String>)opaqueAction.getLanguages(), (List<String>)opaqueAction.getBodies(), (Element)opaqueAction, diagnostics, context);
    }

    public boolean validateOpaqueBehavior(@NonNull OpaqueBehavior opaqueBehavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return INSTANCE.validateOpaqueElement((List<String>)opaqueBehavior.getLanguages(), (List<String>)opaqueBehavior.getBodies(), (Element)opaqueBehavior, diagnostics, context);
    }

    public boolean validateOpaqueExpression(@NonNull OpaqueExpression opaqueExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return INSTANCE.validateOpaqueElement((List<String>)opaqueExpression.getLanguages(), (List<String>)opaqueExpression.getBodies(), (Element)opaqueExpression, diagnostics, context);
    }

    protected boolean validateOpaqueElement(List<String> languages, List<String> bodies, @NonNull Element opaqueElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (context != null) {
            int i = 0;
            while (i < bodies.size()) {
                if (i >= languages.size() || "OCL".equals(languages.get(i))) {
                    try {
                        String body = bodies.get(i);
                        if (body != null) {
                            if (VALIDATE_OPAQUE_ELEMENT.isActive()) {
                                VALIDATE_OPAQUE_ELEMENT.println("OCL: " + body);
                            }
                            if (!this.validateSyntax1(body, opaqueElement, diagnostics, context) && diagnostics == null) {
                                allOk = false;
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (diagnostics != null) {
                            String objectLabel = EObjectValidator.getObjectLabel((EObject)opaqueElement, context);
                            String message = NLS.bind((String)"Body language processing error {0} on {1}", (Object)e, (Object)objectLabel);
                            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                        }
                        allOk = false;
                    }
                }
                ++i;
            }
        }
        return allOk;
    }

    protected boolean validateSemantics(@NonNull Element umlElement, @NonNull ExpressionInOCL expressionInOCL, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Diagnostician nestedDiagnostician = Diagnostician.INSTANCE;
        BasicDiagnostic nestedDiagnostic = nestedDiagnostician.createDefaultDiagnostic((EObject)umlElement);
        HashMap<Object, Object> nestedContext = new HashMap<Object, Object>(context);
        nestedContext.remove("org.eclipse.emf.ecore.EObject_NoCircularContainment");
        if (!nestedDiagnostician.validate((EObject)expressionInOCL, (DiagnosticChain)nestedDiagnostic, nestedContext)) {
            if (diagnostics != null) {
                StringBuilder s = new StringBuilder();
                s.append("OCL Validation error for \"" + expressionInOCL.getBody() + "\"");
                for (Diagnostic childDiagnostic : nestedDiagnostic.getChildren()) {
                    if (childDiagnostic == null) continue;
                    s.append("\n\t");
                    s.append(childDiagnostic.getMessage());
                }
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, s.toString(), new Object[]{umlElement}));
            }
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validateSyntax1(@NonNull String body, @NonNull Element opaqueElement, @Nullable DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        block11: {
            block10: {
                ocl = PivotDiagnostician.getOCL(context, (EObject)opaqueElement);
                environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
                asSpecification = (ExpressionInOCL)environmentFactory.getASOf(ExpressionInOCL.class, (EObject)opaqueElement);
                if (asSpecification != null) break block10;
                if (diagnostics != null) {
                    objectLabel = LabelUtil.getLabel((Object)opaqueElement);
                    message = StringUtil.bind((String)"No pivot for {0}", (Object[])new Object[]{objectLabel});
                    if (!this.mayUseNewLines) {
                        message = message.replace("\n", " ");
                    }
                    diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity((EnvironmentFactory)environmentFactory), "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                }
                return false;
            }
            try {
                asResource = asSpecification.eResource();
                if (diagnostics != null && (asResource.getErrors().size() > 0 || asResource.getWarnings().size() > 0)) {
                    this.propagateProblems(diagnostics, asResource, EcoreUtil.getRootContainer((EObject)opaqueElement));
                }
                asQuery = environmentFactory.parseSpecification((LanguageExpression)asSpecification);
                return this.validateSemantics(opaqueElement, asQuery, diagnostics, context);
            }
            catch (ParserException e) {
                if (diagnostics == null) break block11;
                data = new Object[]{opaqueElement};
                fullMessage = e.getMessage();
                messages = fullMessage.split("\n");
                titleDiagnostic = null;
                severity = PivotUtil.getSeverity((EnvironmentFactory)environmentFactory);
                var16_18 = messages;
                var15_19 = messages.length;
                var14_20 = 0;
                ** while (var14_20 < var15_19)
            }
lbl-1000:
            // 1 sources

            {
                message = var16_18[var14_20];
                if (titleDiagnostic == null) {
                    titleDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore.model", 0, fullMessage, data);
                } else {
                    titleDiagnostic.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, data));
                }
                ++var14_20;
                continue;
            }
lbl38:
            // 1 sources

            if (titleDiagnostic != null) {
                diagnostics.add(titleDiagnostic);
            }
        }
        return false;
    }

    protected boolean validateSyntax2(@NonNull EObject instance, @NonNull String body, @NonNull Element opaqueElement, @Nullable DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        ExpressionInOCL asSpecification;
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
        ExpressionInOCL asQuery;
        OCL ocl;
        block8: {
            ocl = PivotDiagnostician.getOCL(context, (EObject)opaqueElement);
            asQuery = null;
            environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
            try {
                asSpecification = (ExpressionInOCL)environmentFactory.getASOf(ExpressionInOCL.class, (EObject)opaqueElement);
                if (asSpecification != null) break block8;
                if (diagnostics != null) {
                    String objectLabel = LabelUtil.getLabel((Object)opaqueElement);
                    String message = StringUtil.bind((String)"No pivot for {0}", (Object[])new Object[]{objectLabel});
                    if (!this.mayUseNewLines) {
                        message = message.replace("\n", " ");
                    }
                    diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity((EnvironmentFactory)environmentFactory), "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                }
                return false;
            }
            catch (ParserException e) {
                if (diagnostics != null) {
                    String objectLabel = LabelUtil.getLabel((Object)opaqueElement);
                    String message = StringUtil.bind((String)PivotMessagesInternal.ParsingError, (Object[])new Object[]{objectLabel, e.getMessage()});
                    if (!this.mayUseNewLines) {
                        message = message.replace("\n", " ");
                    }
                    diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity((EnvironmentFactory)environmentFactory), "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                }
                return false;
            }
        }
        asQuery = environmentFactory.parseSpecification((LanguageExpression)asSpecification);
        if (!this.validateSemantics(opaqueElement, asQuery, diagnostics, context)) {
            return false;
        }
        EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor((Object)instance, asQuery);
        AbstractConstraintEvaluator constraintEvaluator = diagnostics != null ? new ConstraintEvaluatorWithDiagnostics(asQuery, instance, diagnostics, instance, this.mayUseNewLines) : new ConstraintEvaluatorWithoutDiagnostics(asQuery);
        return (Boolean)constraintEvaluator.evaluate(evaluationVisitor);
    }

    private static final class ASResourceProblems
    extends BasicDiagnostic {
        private @NonNull Resource asResource;

        public ASResourceProblems(@NonNull Resource asResource, @Nullable EObject umlElement) {
            Object[] objectArray;
            int n = asResource.getErrors().size() > 0 ? 4 : 2;
            if (umlElement != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = umlElement;
            } else {
                objectArray = null;
            }
            super(n, PivotMessages.Validation, 0, null, objectArray);
            this.asResource = asResource;
        }

        public @NonNull Resource getASResource() {
            return this.asResource;
        }

        public String getMessage() {
            if (this.message == null) {
                boolean isFirst = true;
                StringBuilder s = new StringBuilder();
                for (Resource.Diagnostic error : this.asResource.getErrors()) {
                    if (!isFirst) {
                        s.append("\n");
                    }
                    s.append(error.getMessage());
                    isFirst = false;
                }
                for (Resource.Diagnostic warning : this.asResource.getWarnings()) {
                    if (!isFirst) {
                        s.append("\n");
                    }
                    s.append(warning.getMessage());
                    isFirst = false;
                }
                this.message = s.toString();
            }
            return super.getMessage();
        }

        public String toString() {
            this.getMessage();
            return super.toString();
        }
    }

    public static class ConstraintEvaluatorWithDiagnostics
    extends AbstractConstraintEvaluator<Boolean> {
        protected final @NonNull EObject eObject;
        protected final @NonNull DiagnosticChain diagnostics;
        protected final @NonNull EObject diagnosticEObject;
        protected final boolean mayUseNewLines;

        public ConstraintEvaluatorWithDiagnostics(@NonNull ExpressionInOCL expression, @NonNull EObject eObject, @NonNull DiagnosticChain diagnostics, @NonNull EObject diagnosticEObject, boolean mayUseNewLines) {
            super(expression);
            this.diagnosticEObject = diagnosticEObject;
            this.eObject = eObject;
            this.diagnostics = diagnostics;
            this.mayUseNewLines = mayUseNewLines;
        }

        protected String getObjectLabel() {
            return NameUtil.qualifiedNameFor((Object)this.eObject);
        }

        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            String message = StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.toString()});
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        protected Boolean handleFailureResult(@Nullable Object result) {
            int severity = this.getConstraintResultSeverity(result);
            String message = this.getConstraintResultMessage(result);
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.uml2.uml", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        protected Boolean handleInvalidExpression(@NonNull String message) {
            String message2 = message;
            if (!this.mayUseNewLines) {
                message2 = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message2.replace("\n", " - "), new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            String message = StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()});
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    public static class ConstraintEvaluatorWithoutDiagnostics
    extends AbstractConstraintEvaluator<Boolean> {
        public ConstraintEvaluatorWithoutDiagnostics(@NonNull ExpressionInOCL expression) {
            super(expression);
        }

        protected String getObjectLabel() {
            throw new UnsupportedOperationException();
        }

        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            return Boolean.FALSE;
        }

        protected Boolean handleFailureResult(@Nullable Object result) {
            return Boolean.FALSE;
        }

        protected Boolean handleInvalidExpression(@NonNull String message) {
            return Boolean.FALSE;
        }

        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            return Boolean.FALSE;
        }

        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }
}

