/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractGeneralizedIdImpl;
import org.eclipse.ocl.pivot.internal.ids.SpecializedLambdaTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference3;

public class GeneralizedLambdaTypeIdImpl
extends AbstractGeneralizedIdImpl<LambdaTypeId>
implements LambdaTypeId,
WeakHashMapOfListOfWeakReference3.MatchableId<String, ParametersId> {
    protected final @NonNull ParametersId parametersId;

    public GeneralizedLambdaTypeIdImpl(@NonNull Integer hashCode, @NonNull String name, @NonNull ParametersId parametersId) {
        super(hashCode, 0, name);
        this.parametersId = parametersId;
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitLambdaTypeId(this);
    }

    @Override
    protected @NonNull LambdaTypeId createSpecializedId(@NonNull BindingsId templateBindings) {
        return new SpecializedLambdaTypeIdImpl(this, templateBindings);
    }

    @Override
    public @NonNull String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        int i = 0;
        while (i < this.parametersId.size()) {
            TypeId parameterId = (TypeId)this.parametersId.get(i);
            assert (parameterId != null);
            if (i == 0) {
                s.append(' ');
                s.append(parameterId.toString());
                s.append('(');
            } else if (i != 1) {
                if (i == 2) {
                    s.append(parameterId.toString());
                } else {
                    s.append(',');
                    s.append(parameterId.toString());
                }
            }
            ++i;
        }
        s.append(") : ");
        if (this.parametersId.size() > 1) {
            TypeId parameterId = (TypeId)this.parametersId.get(1);
            assert (parameterId != null);
            s.append(parameterId.toString());
        } else {
            s.append("?");
        }
        return s.toString();
    }

    @Override
    public @NonNull LambdaTypeId getGeneralizedId() {
        return this;
    }

    @Override
    public boolean isTemplated() {
        for (TypeId typeId : this.parametersId) {
            if (!typeId.isTemplated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "LambdaType";
    }

    @Override
    public @NonNull ParametersId getParametersId() {
        return this.parametersId;
    }

    @Override
    public boolean matches(@NonNull String thatName, @NonNull ParametersId thatParametersId) {
        if (this.parametersId != thatParametersId) {
            return false;
        }
        return this.name.equals(thatName);
    }

    @Override
    public @NonNull LambdaTypeId specialize(@NonNull BindingsId templateBindings) {
        return this.createSpecializedId(templateBindings);
    }
}

