/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.internal.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class PapyrusProblemEditorPart
extends ProblemEditorPart {
    private static final String LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";

    protected void createButtons(Composite buttonComposite) {
        this.editorToOpen = null;
        super.createButtons(buttonComposite);
        this.createShowLogButton(buttonComposite);
    }

    private void createShowLogButton(Composite parent) {
        IViewDescriptor descriptor = PlatformUI.getWorkbench().getViewRegistry().find(LOG_VIEW_ID);
        if (descriptor == null) {
            return;
        }
        Button button = new Button(parent, 8);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(LOG_VIEW_ID);
            }
            catch (CoreException ce) {
                Activator.log.error((Throwable)ce);
            }
        }));
        Image image = descriptor.getImageDescriptor().createImage();
        button.setImage(image);
        button.setToolTipText(Messages.PapyrusProblemEditorPart_ShowErrorLogView);
        button.addDisposeListener(e -> image.dispose());
    }
}

