/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.utils.IObservableList;
import org.eclipse.papyrus.infra.core.sasheditor.utils.IObservableListListener;

public class ObservableList<T>
extends ArrayList<T>
implements IObservableList<T> {
    private static final long serialVersionUID = 1L;
    private List<IObservableListListener<T>> listeners = new ArrayList<IObservableListListener<T>>();

    public ObservableList() {
    }

    public ObservableList(int initialCapacity) {
        super(initialCapacity);
    }

    protected List<IObservableListListener<T>> getListeners() {
        return this.listeners;
    }

    @Override
    public void addListener(IObservableListListener<T> listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IObservableListListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void fireElementAddedEvent(T element) {
        for (IObservableListListener<T> listener : this.listeners) {
            listener.elementAdded(element);
        }
    }

    public void fireElementRemovedEvent(T element) {
        for (IObservableListListener<T> listener : this.listeners) {
            listener.elementRemoved(element);
        }
    }

    @Override
    public boolean add(T e) {
        boolean res = super.add(e);
        this.fireElementAddedEvent(e);
        return res;
    }

    @Override
    public boolean remove(Object o) {
        boolean res = super.remove(o);
        this.fireElementRemovedEvent(o);
        return res;
    }
}

