/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;

public class ServerExists
extends AbstractWaitCondition {
    private ServersView2 view;
    private String name;

    public ServerExists(String name) {
        this.name = name;
        this.view = new ServersView2();
        this.view.open();
    }

    public boolean test() {
        try {
            this.view.getServer(this.name);
            return true;
        }
        catch (RedDeerException redDeerException) {
            return false;
        }
    }

    public String description() {
        return "there is server with name: " + this.name;
    }

    public String errorMessageWhile() {
        return "server with name: '" + this.name + "' has been found.";
    }

    public String errorMessageUntil() {
        List servers = this.view.getServers().stream().map(it -> it.getLabel().getName()).collect(Collectors.toList());
        return "server with name: '" + this.name + "' has not been found. Existing servers: " + servers.toString();
    }
}

