/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;

final class StreamListenerProxy
implements IStreams.StreamsListener,
IChannelManager.IStreamsListenerProxy {
    private final IChannel channel;
    private final String streamType;
    ListenerList listeners = new ListenerList();
    private final List<StreamCreatedEvent> delayedCreatedEvents = new ArrayList<StreamCreatedEvent>();

    public StreamListenerProxy(final IChannel channel, String streamType) {
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)streamType);
        this.channel = channel;
        this.channel.addChannelListener(new IChannel.IChannelListener(){

            public void onChannelOpened() {
            }

            public void onChannelClosed(Throwable error) {
                channel.removeChannelListener((IChannel.IChannelListener)this);
                Object[] candidates = StreamListenerProxy.this.listeners.getListeners();
                StreamListenerProxy.this.listeners.clear();
                Object[] objectArray = candidates;
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    if (listener instanceof IDisposable) {
                        ((IDisposable)listener).dispose();
                    }
                    ++n2;
                }
            }

            public void congestionLevel(int level) {
            }
        });
        this.streamType = streamType;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void addListener(IChannelManager.IStreamsListener listener) {
        Assert.isNotNull((Object)listener);
        listener.setProxy(this);
        this.listeners.add((Object)listener);
    }

    public void removeListener(IChannelManager.IStreamsListener listener) {
        Assert.isNotNull((Object)listener);
        listener.setProxy(null);
        this.listeners.remove((Object)listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDelayedCreatedEvents() {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
            CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: processDelayedCreatedEvents()", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
        }
        List<StreamCreatedEvent> list = this.delayedCreatedEvents;
        synchronized (list) {
            StreamCreatedEvent[] events = this.delayedCreatedEvents.toArray(new StreamCreatedEvent[this.delayedCreatedEvents.size()]);
            this.delayedCreatedEvents.clear();
            StreamCreatedEvent[] streamCreatedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                StreamCreatedEvent event = streamCreatedEventArray[n2];
                this.created(event.streamType, event.streamId, event.contextId);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void created(String stream_type, String stream_id, String context_id) {
        IStreams service;
        Assert.isNotNull((Object)stream_type);
        Assert.isNotNull((Object)stream_id);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
            CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: created(" + stream_type + ", " + stream_id + ", " + context_id + ")", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
        }
        if (context_id == null) {
            IStreams service2 = (IStreams)this.channel.getRemoteService(IStreams.class);
            if (service2 != null) {
                service2.disconnect(stream_id, new IStreams.DoneDisconnect(){

                    public void doneDisconnect(IToken token, Exception error) {
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                            CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: disconnect -> context id must be not null.", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
                        }
                    }
                });
            }
            return;
        }
        boolean delayed = false;
        boolean disconnect = true;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            IChannelManager.IStreamsListener listener = (IChannelManager.IStreamsListener)l;
            if (!listener.hasContext()) {
                delayed |= true;
            } else {
                boolean consume = listener.isCreatedConsumed(stream_type, stream_id, context_id);
                if (consume) {
                    listener.created(stream_type, stream_id, context_id);
                }
                disconnect &= !consume;
            }
            ++n2;
        }
        if (delayed) {
            StreamCreatedEvent event = new StreamCreatedEvent(stream_type, stream_id, context_id);
            List<StreamCreatedEvent> list = this.delayedCreatedEvents;
            synchronized (list) {
                if (!this.delayedCreatedEvents.contains(event)) {
                    this.delayedCreatedEvents.add(event);
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                        CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: delayed -> at least one listener does not have a context set", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
                    }
                }
            }
            return;
        }
        if (disconnect && (service = (IStreams)this.channel.getRemoteService(IStreams.class)) != null) {
            service.disconnect(stream_id, new IStreams.DoneDisconnect(){

                public void doneDisconnect(IToken token, Exception error) {
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                        CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: disconnect -> not interested in context id", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(String stream_type, String stream_id) {
        Assert.isNotNull((Object)stream_type);
        Assert.isNotNull((Object)stream_id);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
            CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: disposed(" + stream_type + ", " + stream_id + ")", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
        }
        List<StreamCreatedEvent> list = this.delayedCreatedEvents;
        synchronized (list) {
            Iterator<StreamCreatedEvent> iterator = this.delayedCreatedEvents.iterator();
            while (iterator.hasNext()) {
                StreamCreatedEvent event = iterator.next();
                if (!stream_type.equals(event.streamType) || !stream_id.equals(event.streamId)) continue;
                iterator.remove();
            }
        }
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IChannelManager.IStreamsListener)l).disposed(stream_type, stream_id);
            ++n2;
        }
    }

    private static final class StreamCreatedEvent {
        public final String streamType;
        public final String streamId;
        public final String contextId;
        private final String toString;

        public StreamCreatedEvent(String streamType, String streamId, String contextId) {
            this.streamType = streamType;
            this.streamId = streamId;
            this.contextId = contextId;
            this.toString = this.toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof StreamCreatedEvent && this.toString().equals(((StreamCreatedEvent)obj).toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            if (this.toString != null) {
                return this.toString;
            }
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(": streamType = ");
            builder.append(this.streamType);
            builder.append("; streamId = ");
            builder.append(this.streamId);
            builder.append("; contextId = ");
            builder.append(this.contextId);
            return builder.toString();
        }
    }
}

