/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class DataSizeWithUnitFormat
extends Format {
    private static final @NonNull Format INSTANCE = new DataSizeWithUnitFormat();
    private static final long serialVersionUID = 3934127385682676804L;
    private static final String B = "B";
    private static final String K = "K";
    private static final String M = "M";
    private static final String G = "G";
    private static final String T = "T";
    private static final String SUFFIX_REPLACEMENT = "%suffix%";
    private static final long KILO = 1024L;
    private static final Format FORMAT = new DecimalFormat("#.###");
    private static final String UNIT_PATTERN_STR = "^[\\s]*([KMGT]?)B%suffix%";
    private static final String SUFFIX = "";
    private final String fSuffix;
    private final Pattern fUnitPattern;

    protected DataSizeWithUnitFormat() {
        this(SUFFIX);
    }

    protected DataSizeWithUnitFormat(String suffix) {
        this.fSuffix = suffix;
        this.fUnitPattern = Pattern.compile(UNIT_PATTERN_STR.replace(SUFFIX_REPLACEMENT, suffix.toUpperCase()));
    }

    public static @NonNull Format getInstance() {
        return INSTANCE;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            double value = num.doubleValue();
            double abs = Math.abs(value);
            if (value == 0.0) {
                return toAppendTo.append("0").append(' ').append(B).append(this.fSuffix);
            }
            if (abs >= 1.099511627776E12) {
                return toAppendTo.append(FORMAT.format(value / 1.099511627776E12)).append(' ').append(T).append(B).append(this.fSuffix);
            }
            if (abs >= 1.073741824E9) {
                return toAppendTo.append(FORMAT.format(value / 1.073741824E9)).append(' ').append(G).append(B).append(this.fSuffix);
            }
            if (abs >= 1048576.0) {
                return toAppendTo.append(FORMAT.format(value / 1048576.0)).append(' ').append(M).append(B).append(this.fSuffix);
            }
            if (abs >= 1024.0) {
                return toAppendTo.append(FORMAT.format(value / 1024.0)).append(' ').append(K).append(B).append(this.fSuffix);
            }
            return toAppendTo.append(FORMAT.format(value)).append(' ').append(B).append(this.fSuffix);
        }
        return toAppendTo;
    }

    @Override
    public Number parseObject(String source, ParsePosition pos) {
        Number number = NumberFormat.getInstance().parse(source, pos);
        if (number == null) {
            return null;
        }
        String remaining = source.substring(pos.getIndex()).toUpperCase();
        Matcher matcher = this.fUnitPattern.matcher(remaining);
        long multiplier = 1L;
        if (matcher.find()) {
            String unitString = matcher.group();
            String prefix = matcher.group(1);
            if (prefix.equals(K)) {
                multiplier = 1024L;
            } else if (prefix.equals(M)) {
                multiplier = 0x100000L;
            } else if (prefix.equals(G)) {
                multiplier = 0x40000000L;
            } else if (prefix.equals(T)) {
                multiplier = 0x10000000000L;
            }
            pos.setIndex(pos.getIndex() + unitString.length());
        }
        if (multiplier != 1L && Double.isFinite(number.doubleValue())) {
            BigDecimal bd = new BigDecimal(number.toString());
            if ((bd = bd.multiply(BigDecimal.valueOf(multiplier))).remainder(BigDecimal.ONE).equals(BigDecimal.ZERO) && bd.abs().compareTo(new BigDecimal(Long.MAX_VALUE)) < 0) {
                return bd.longValue();
            }
            return bd.doubleValue();
        }
        return number;
    }
}

