/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.generic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.generic.SimpleContainerConfigurable;
import org.eclipse.wb.internal.core.xml.model.generic.SimpleContainerConfiguration;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleContainerFactory {
    private final XmlObjectInfo m_object;
    private final boolean m_forCanvas;

    public SimpleContainerFactory(XmlObjectInfo object, boolean forCanvas) {
        this.m_object = object;
        this.m_forCanvas = forCanvas;
    }

    public List<SimpleContainer> get() {
        ArrayList containers = Lists.newArrayList();
        this.addConfigurableContainers(containers);
        return containers;
    }

    private void addConfigurableContainers(List<SimpleContainer> containers) {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations();
        for (SimpleContainerConfiguration configuration : configurations) {
            SimpleContainerConfigurable container = new SimpleContainerConfigurable(this.m_object, configuration);
            containers.add(container);
        }
    }

    public List<SimpleContainerConfiguration> getConfigurations() {
        ArrayList configurations = Lists.newArrayList();
        for (String prefix : this.getConfigurationPrefixes()) {
            SimpleContainerConfiguration configuration = this.createConfiguration(prefix);
            configurations.add(configuration);
        }
        return configurations;
    }

    private List<String> getConfigurationPrefixes() {
        ArrayList prefixes = Lists.newArrayList();
        this.addConfigurationPrefixes(prefixes, "simpleContainer");
        if (this.m_forCanvas) {
            this.addConfigurationPrefixes(prefixes, "simpleContainer.canvas");
        } else {
            this.addConfigurationPrefixes(prefixes, "simpleContainer.tree");
        }
        return prefixes;
    }

    private void addConfigurationPrefixes(List<String> prefixes, String basePrefix) {
        int i = 0;
        while (i < 10) {
            String prefix = String.valueOf(basePrefix) + (i == 0 ? "" : "." + i);
            String validatorText = this.getParameter(prefix);
            if (validatorText != null && ContainerObjectValidators.validateContainer((Object)((Object)this.m_object), (String)validatorText)) {
                prefixes.add(prefix);
            }
            ++i;
        }
    }

    private SimpleContainerConfiguration createConfiguration(String prefix) {
        return new SimpleContainerConfiguration(this.getComponentValidator(prefix), this.getAssociation(prefix));
    }

    private ContainerObjectValidator getComponentValidator(String prefix) {
        String validatorExpression = this.getParameter(String.valueOf(prefix) + ".component-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forComponentExpression((String)validatorExpression);
        }
        String componentString = this.getComponentString(prefix);
        Assert.isNotNull((Object)componentString, (String)"No 'component' validator.");
        String[] componentTypes = StringUtils.split((String)componentString);
        return ContainerObjectValidators.forList((String[])componentTypes);
    }

    private String getComponentString(String prefix) {
        String componentString = this.getParameter(String.valueOf(prefix) + ".component");
        if (componentString == null) {
            componentString = this.getParameter("simpleContainer.defaultComponent");
        }
        return componentString;
    }

    private Association getAssociation(String prefix) {
        String associationString = this.getParameter(String.valueOf(prefix) + ".x-association");
        if (associationString == null) {
            return Associations.direct();
        }
        if (associationString.startsWith("inter ")) {
            associationString = StringUtils.removeStart((String)associationString, (String)"inter ");
            String tag = StringUtils.substringBefore((String)associationString, (String)" ");
            associationString = StringUtils.substringAfter((String)associationString, (String)" ");
            Map<String, String> attributes = SimpleContainerFactory.parseAttributes(associationString);
            return Associations.intermediate(tag, attributes);
        }
        Assert.isTrue((boolean)associationString.startsWith("property "));
        String property = StringUtils.removeStart((String)associationString, (String)"property ");
        return Associations.property(property);
    }

    private static Map<String, String> parseAttributes(String s) {
        HashMap attributes = Maps.newHashMap();
        while (s.length() != 0) {
            s = s.trim();
            int attrNameEnd = s.indexOf("='");
            int attrValueEnd = s.indexOf("'", attrNameEnd + 2);
            String attrName = s.substring(0, attrNameEnd);
            String attrValue = s.substring(attrNameEnd + 2, attrValueEnd);
            attributes.put(attrName, attrValue);
            s = s.substring(attrValueEnd + 1);
        }
        return attributes;
    }

    private String getParameter(String name) {
        return XmlObjectUtils.getParameter(this.m_object, name);
    }
}

