"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var less_1 = __importDefault(require("less"));
var sass_1 = __importDefault(require("sass"));
var icss_utils_1 = require("icss-utils");
exports.getFileType = function (fileName) {
    if (fileName.endsWith('.css'))
        return "css" /* css */;
    if (fileName.endsWith('.less'))
        return "less" /* less */;
    return "scss" /* scss */;
};
var getFilePath = function (fileName) {
    return fileName.substring(0, fileName.lastIndexOf('/'));
};
exports.getClasses = function (processor, css, fileName, options, logger) {
    try {
        var fileType = exports.getFileType(fileName);
        var rendererOptions = options.rendererOptions || {};
        var transformedCss_1 = '';
        if (options.customRenderer) {
            // eslint-disable-next-line @typescript-eslint/no-var-requires
            var customRenderer = require(options.customRenderer);
            transformedCss_1 = customRenderer(css, { fileName: fileName, logger: logger });
        }
        else if (fileType === "less" /* less */) {
            less_1.default.render(css, __assign({ syncImport: true, filename: fileName }, (rendererOptions.less || {})), function (error, output) {
                if (error)
                    throw error;
                transformedCss_1 = output.css.toString();
            });
        }
        else if (fileType === "scss" /* scss */) {
            var filePath = getFilePath(fileName);
            var _a = rendererOptions.sass || {}, includePaths = _a.includePaths, sassOptions = __rest(_a, ["includePaths"]);
            transformedCss_1 = sass_1.default
                .renderSync(__assign({ data: css, includePaths: __spreadArrays([filePath, 'node_modules'], (includePaths || [])) }, sassOptions))
                .css.toString();
        }
        else {
            transformedCss_1 = css;
        }
        var processedCss = processor.process(transformedCss_1, {
            from: fileName,
        });
        return processedCss.root ? icss_utils_1.extractICSS(processedCss.root).icssExports : {};
    }
    catch (e) {
        console.log(e);
        logger.error(e);
        return {};
    }
};
