/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.transformer;

import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.Part;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentTransformer
implements ITransformer {
    protected Controller controller;

    public FragmentTransformer(Controller controller) {
        this.controller = controller;
    }

    public Hashtable normalize(Hashtable properties) {
        StringBuffer sb = new StringBuffer();
        sb.append("<root>");
        WSDLOperationElement operElement = (WSDLOperationElement)this.controller.getWSDLPerspective().getNodeManager().getSelectedNode().getTreeElement();
        for (Part part : operElement.getOrderedBodyParts()) {
            IXSDFragment frag = operElement.getFragment(part);
            Element[] elements = new Element[]{};
            try {
                elements = frag.genInstanceDocumentsFromParameterValues(!operElement.isUseLiteral(), new Hashtable(), XMLUtils.createNewDocument(null));
            }
            catch (ParserConfigurationException parserConfigurationException) {}
            int i = 0;
            while (i < elements.length) {
                sb.append(XMLUtils.serialize(elements[i], true));
                ++i;
            }
        }
        sb.append("</root>");
        properties.put("::sourceContent", sb.toString());
        return properties;
    }

    public Hashtable deNormalize(Hashtable properties) {
        String source = (String)properties.get("::sourceContent");
        if (source != null) {
            try {
                Element root = XMLUtils.stringToElement(source);
                if (root != null) {
                    NodeList childNodes = root.getChildNodes();
                    Vector<Node> childrenVector = new Vector<Node>();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        Node child = childNodes.item(i);
                        if (child instanceof Element) {
                            childrenVector.add(child);
                        }
                        ++i;
                    }
                    Element[] children = childrenVector.toArray(new Element[0]);
                    WSDLOperationElement operElement = (WSDLOperationElement)this.controller.getWSDLPerspective().getNodeManager().getSelectedNode().getTreeElement();
                    for (Part part : operElement.getOrderedBodyParts()) {
                        IXSDFragment frag = operElement.getFragment(part);
                        frag.setParameterValuesFromInstanceDocuments(children);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return properties;
    }
}

