/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.shared.ui.MetamodelContributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.typesystem.xsd.ui.XSDBuilderConfigurator;
import org.eclipse.xtend.typesystem.xsd.ui.XSDMetamodelContributor;
import org.eclipse.xtend.typesystem.xsd.ui.XSDMetamodelStore;
import org.osgi.framework.BundleContext;

public class XSDToolsPlugin
extends AbstractUIPlugin {
    private static XSDToolsPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.xtend.typesystem.xsd.ui";
    public static boolean trace;
    private XSDBuilderConfigurator builderConfigurator = new XSDBuilderConfigurator();
    private XSDMetamodelStore store = new XSDMetamodelStore();

    static {
        trace = false;
    }

    public static XSDToolsPlugin getDefault() {
        if (plugin == null) {
            XSDToolsPlugin.traceLog("Access to XSDToolsPlugin before the plugin has been initialized!");
        }
        return plugin;
    }

    public static boolean isXSDProject(IProject proj) {
        IJavaProject jp = JavaCore.create((IProject)proj);
        if (jp == null) {
            return false;
        }
        for (MetamodelContributor c : MetamodelContributorRegistry.getActiveMetamodelContributors((IJavaProject)jp)) {
            if (!(c instanceof XSDMetamodelContributor)) continue;
            return true;
        }
        return false;
    }

    public static void traceLog(String msg) {
        if (trace) {
            System.out.println("XSD adapter [" + Thread.currentThread().getName() + "]: " + msg);
        }
    }

    public XSDToolsPlugin() {
        plugin = this;
    }

    public XSDMetamodelStore getXSDStore() {
        return this.store;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        XSDToolsPlugin.traceLog(String.valueOf(((Object)((Object)this)).getClass().getName()) + " started");
        this.builderConfigurator = new XSDBuilderConfigurator();
        this.store = new XSDMetamodelStore();
        this.builderConfigurator.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.builderConfigurator.stop();
        plugin = null;
        super.stop(context);
        XSDToolsPlugin.traceLog(String.valueOf(((Object)((Object)this)).getClass().getName()) + " stopped");
    }
}

