/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.common.base.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.RuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.SubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.WebProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.XtextProjectConfig;

@Accessors
public class StandardProjectConfig
extends XtextProjectConfig {
    private boolean mavenLayout;
    private boolean createEclipseMetaData;
    private String rootPath;
    private String baseName;

    @Mandatory
    public String setBaseName(String baseName) {
        this.baseName = baseName;
        return this.baseName;
    }

    @Mandatory
    public String setRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this.rootPath;
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.rootPath == null) {
            issues.addError("The property 'rootPath' must be set", this);
        }
        if (this.baseName == null) {
            issues.addError("The property 'baseName' must be set", this);
        }
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        Consumer<SubProjectConfig> _function = it -> {
            String _iconsPath;
            boolean _tripleEquals_5;
            String _srcGenPath;
            boolean _tripleEquals_4;
            String _srcPath;
            boolean _tripleEquals_3;
            String _metaInfPath;
            boolean _tripleEquals_2;
            String _rootPath;
            boolean _tripleEquals_1;
            boolean _tripleEquals;
            String _name = it.getName();
            boolean bl = _tripleEquals = _name == null;
            if (_tripleEquals) {
                it.setName(this.computeName((SubProjectConfig)it));
            }
            boolean bl2 = _tripleEquals_1 = (_rootPath = it.getRootPath()) == null;
            if (_tripleEquals_1) {
                it.setRoot(this.computeRoot((SubProjectConfig)it));
            }
            boolean bl3 = _tripleEquals_2 = (_metaInfPath = it.getMetaInfPath()) == null;
            if (_tripleEquals_2) {
                it.setMetaInf(this.computeMetaInf((SubProjectConfig)it));
            }
            boolean bl4 = _tripleEquals_3 = (_srcPath = it.getSrcPath()) == null;
            if (_tripleEquals_3) {
                it.setSrc(this.computeSrc((SubProjectConfig)it));
            }
            boolean bl5 = _tripleEquals_4 = (_srcGenPath = it.getSrcGenPath()) == null;
            if (_tripleEquals_4) {
                it.setSrcGen(this.computeSrcGen((SubProjectConfig)it));
            }
            boolean bl6 = _tripleEquals_5 = (_iconsPath = it.getIconsPath()) == null;
            if (_tripleEquals_5) {
                it.setIcons(this.computeIcons((SubProjectConfig)it));
            }
            if (it instanceof BundleProjectConfig && this.createEclipseMetaData) {
                PluginXmlAccess _pluginXml;
                boolean _tripleEquals_7;
                boolean _tripleEquals_6;
                ManifestAccess _manifest = ((BundleProjectConfig)it).getManifest();
                boolean bl7 = _tripleEquals_6 = _manifest == null;
                if (_tripleEquals_6) {
                    ((BundleProjectConfig)it).setManifest(this.newManifestAccess());
                }
                boolean bl8 = _tripleEquals_7 = (_pluginXml = ((BundleProjectConfig)it).getPluginXml()) == null;
                if (_tripleEquals_7) {
                    ((BundleProjectConfig)it).setPluginXml(this.newPluginXmlAccess());
                }
            }
            if (it instanceof RuntimeProjectConfig) {
                boolean _tripleEquals_8;
                String _ecoreModelPath = ((RuntimeProjectConfig)it).getEcoreModelPath();
                boolean bl9 = _tripleEquals_8 = _ecoreModelPath == null;
                if (_tripleEquals_8) {
                    ((RuntimeProjectConfig)it).setEcoreModel(this.computeEcoreModel((RuntimeProjectConfig)it));
                }
            }
            if (it instanceof WebProjectConfig) {
                boolean _tripleEquals_9;
                String _assetsPath = ((WebProjectConfig)it).getAssetsPath();
                boolean bl10 = _tripleEquals_9 = _assetsPath == null;
                if (_tripleEquals_9) {
                    ((WebProjectConfig)it).setAssets(this.computeAssets((WebProjectConfig)it));
                }
            }
        };
        this.getEnabledProjects().forEach(_function);
    }

    protected String computeName(SubProjectConfig project) {
        WebProjectConfig _web;
        BundleProjectConfig _eclipsePluginTest;
        BundleProjectConfig _eclipsePlugin;
        BundleProjectConfig _genericIde;
        BundleProjectConfig _runtimeTest;
        String _switchResult = null;
        boolean _matched = false;
        RuntimeProjectConfig _runtime = this.getRuntime();
        if (Objects.equal((Object)project, (Object)_runtime)) {
            _matched = true;
            _switchResult = this.baseName;
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_runtimeTest = this.getRuntimeTest()))) {
            _matched = true;
            String _xifexpression = null;
            _xifexpression = !this.mavenLayout ? this.baseName + ".tests" : this.baseName;
            _switchResult = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_genericIde = this.getGenericIde()))) {
            _matched = true;
            _switchResult = this.baseName + ".ide";
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_eclipsePlugin = this.getEclipsePlugin()))) {
            _matched = true;
            _switchResult = this.baseName + ".ui";
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_eclipsePluginTest = this.getEclipsePluginTest()))) {
            _matched = true;
            String _xifexpression_1 = null;
            _xifexpression_1 = !this.mavenLayout ? this.baseName + ".ui.tests" : this.baseName + ".ui";
            _switchResult = _xifexpression_1;
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_web = this.getWeb()))) {
            _matched = true;
            _switchResult = this.baseName + ".web";
        }
        return _switchResult;
    }

    protected String computeRoot(SubProjectConfig project) {
        String _name = project.getName();
        return this.rootPath + "/" + _name;
    }

    protected String computeSrc(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = _rootPath + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = _plus_1 + "/java";
        } else {
            _xifexpression = "src";
        }
        return _plus + _xifexpression;
    }

    protected String computeSrcGen(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = _rootPath + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = _plus_1 + "/xtext-gen";
        } else {
            _xifexpression = "src-gen";
        }
        return _plus + _xifexpression;
    }

    protected String computeMetaInf(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = _rootPath + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = _plus_1 + "/resources/META-INF";
        } else {
            _xifexpression = "META-INF";
        }
        return _plus + _xifexpression;
    }

    protected String computeEcoreModel(RuntimeProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = _rootPath + "/";
        return _plus + "model/generated";
    }

    protected String computeAssets(WebProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = _rootPath + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = _plus_1 + "/webapp";
        } else {
            _xifexpression = "WebRoot";
        }
        return _plus + _xifexpression;
    }

    protected String computeSourceSet(SubProjectConfig project) {
        String _xifexpression = null;
        boolean _contains = this.getTestProjects().contains(project);
        _xifexpression = _contains ? "test" : "main";
        return _xifexpression;
    }

    protected String computeIcons(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = _rootPath + "/";
        return _plus + "icons";
    }

    @Pure
    public boolean isMavenLayout() {
        return this.mavenLayout;
    }

    public void setMavenLayout(boolean mavenLayout) {
        this.mavenLayout = mavenLayout;
    }

    @Pure
    public boolean isCreateEclipseMetaData() {
        return this.createEclipseMetaData;
    }

    public void setCreateEclipseMetaData(boolean createEclipseMetaData) {
        this.createEclipseMetaData = createEclipseMetaData;
    }

    @Pure
    public String getRootPath() {
        return this.rootPath;
    }

    @Pure
    public String getBaseName() {
        return this.baseName;
    }
}

