/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltInForString;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.NonNumericalException;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.core.TokenMgrError;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedGetMessageWithoutStackTop;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template._TemplateAPI;
import java.io.StringReader;

class BuiltInsForStringsMisc {
    private BuiltInsForStringsMisc() {
    }

    static class booleanBI
    extends BuiltInForString {
        booleanBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            boolean b;
            if (s.equals("true")) {
                b = true;
            } else if (s.equals("false")) {
                b = false;
            } else if (s.equals(env.getTrueStringValue())) {
                b = true;
            } else if (s.equals(env.getFalseStringValue())) {
                b = false;
            } else {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Can't convert this string to boolean: ", new _DelayedJQuote(s)});
            }
            return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class evalBI
    extends BuiltInForString {
        evalBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            SimpleCharStream scs = new SimpleCharStream(new StringReader("(" + s + ")"), -1000000000, 1, s.length() + 2);
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.incompatibleImprovements = _TemplateAPI.getTemplateLanguageVersionAsInt(this);
            token_source.SwitchTo(2);
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            Expression exp = null;
            try {
                try {
                    exp = parser.Expression();
                }
                catch (TokenMgrError e) {
                    throw e.toParseException(this.getTemplate());
                }
            }
            catch (ParseException e) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
            try {
                return exp.eval(env);
            }
            catch (TemplateException e) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
        }
    }

    static class numberBI
    extends BuiltInForString {
        numberBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s));
            }
            catch (NumberFormatException nfe) {
                throw NonNumericalException.newMalformedNumberException(this, s, env);
            }
        }
    }
}

