/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.v2_0;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwtjsonrpc.client.JsonUtil;
import com.google.gwtjsonrpc.client.RemoteJsonException;
import com.google.gwtjsonrpc.client.event.RpcCompleteEvent;
import com.google.gwtjsonrpc.client.impl.AbstractJsonProxy;
import com.google.gwtjsonrpc.client.impl.JsonCall;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;

abstract class JsonCall20<T>
extends JsonCall<T> {
    protected static int lastRequestId = 0;
    protected int requestId;

    JsonCall20(AbstractJsonProxy abstractJsonProxy, String methodName, String requestParams, ResultDeserializer<T> resultDeserializer, AsyncCallback<T> callback) {
        super(abstractJsonProxy, methodName, requestParams, resultDeserializer, callback);
    }

    public void onResponseReceived(Request req, Response rsp) {
        int sc = rsp.getStatusCode();
        if (JsonCall20.isJsonBody(rsp)) {
            RpcResult r;
            try {
                r = JsonCall20.parse(jsonParser, rsp.getText());
            }
            catch (RuntimeException e) {
                RpcCompleteEvent.fire(this);
                this.callback.onFailure((Throwable)new InvocationException("Bad JSON response: " + e));
                return;
            }
            if (r.xsrfKey() != null) {
                this.proxy.getXsrfManager().setToken(this.proxy, r.xsrfKey());
            }
            if (r.error() != null) {
                String errmsg = r.error().message();
                if ("Invalid xsrfKey in request".equals(errmsg)) {
                    if (this.attempts < 2) {
                        this.send();
                    } else {
                        RpcCompleteEvent.fire(this);
                        this.callback.onFailure((Throwable)new InvocationException(errmsg));
                    }
                } else {
                    RpcCompleteEvent.fire(this);
                    this.callback.onFailure((Throwable)new RemoteJsonException(errmsg, r.error().code(), new JSONObject((JavaScriptObject)r.error()).get("data")));
                }
                return;
            }
            if (sc == 200) {
                RpcCompleteEvent.fire(this);
                JsonUtil.invoke(this.resultDeserializer, this.callback, r);
                return;
            }
        }
        if (sc == 200) {
            RpcCompleteEvent.fire(this);
            this.callback.onFailure((Throwable)new InvocationException("No JSON response"));
        } else {
            RpcCompleteEvent.fire(this);
            this.callback.onFailure((Throwable)new StatusCodeException(sc, rsp.getStatusText()));
        }
    }

    protected static boolean isJsonBody(Response rsp) {
        String type = rsp.getHeader("Content-Type");
        if (type == null) {
            return false;
        }
        int semi = type.indexOf(59);
        if (semi >= 0) {
            type = type.substring(0, semi).trim();
        }
        return "application/json,application/json,application/jsonrequest".contains(type);
    }

    private static final native RpcResult parse(JavaScriptObject var0, String var1);

    private static class RpcError
    extends JavaScriptObject {
        protected RpcError() {
        }

        final native String message();

        final native int code();
    }

    private static class RpcResult
    extends JavaScriptObject {
        protected RpcResult() {
        }

        final native RpcError error();

        final native String xsrfKey();
    }
}

