/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.memory.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.function.Consumer;
import org.eclipse.cdt.debug.core.memory.transport.FileImport;
import org.eclipse.cdt.debug.core.memory.transport.ImportRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;

public final class RAWBinaryImport
extends FileImport<FileInputStream> {
    public RAWBinaryImport(File input, ImportRequest request, Consumer<BigInteger> scroll) {
        super(input, request, scroll);
    }

    @Override
    protected FileInputStream input(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    @Override
    protected void transfer(FileInputStream input, BigInteger factor, IProgressMonitor monitor) throws IOException, DebugException {
        byte[] byteValues = new byte[1024];
        int actualByteCount = input.read(byteValues);
        BigInteger recordAddress = this.start;
        while (actualByteCount != -1 && !monitor.isCanceled()) {
            byte[] data = new byte[actualByteCount];
            int i = 0;
            while (i < data.length) {
                data[i] = byteValues[i];
                ++i;
            }
            this.write.to(recordAddress.subtract(this.base), data);
            BigInteger jobCount = BigInteger.valueOf(actualByteCount).divide(factor);
            monitor.worked(jobCount.intValue());
            recordAddress = recordAddress.add(BigInteger.valueOf(actualByteCount));
            this.scroll.accept(recordAddress);
            actualByteCount = input.read(byteValues);
        }
    }
}

