/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.annotation.Nullable;

public class AnonymousId {
    @Nullable
    private static UUID anonymousId;

    public static synchronized UUID getId() {
        if (anonymousId == null) {
            try {
                anonymousId = AnonymousId.readOrCreateUUID();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return Objects.requireNonNull(anonymousId);
    }

    private static UUID readOrCreateUUID() throws IOException {
        File idFile = new File(SystemUtils.getUserHome(), ".eclipse/org.eclipse.epp.logging.aeri/anonymousId");
        if (idFile.exists()) {
            String uuid = Files.readFirstLine((File)idFile, (Charset)Charsets.UTF_8);
            return UUID.fromString(uuid);
        }
        idFile.getParentFile().mkdirs();
        File oldIdFile = new File(SystemUtils.getUserHome(), ".eclipse/org.eclipse.recommenders/anonymousId");
        if (!oldIdFile.exists()) {
            UUID uuid = UUID.randomUUID();
            Files.write((CharSequence)uuid.toString(), (File)idFile, (Charset)Charsets.UTF_8);
            return uuid;
        }
        idFile.getParentFile().mkdirs();
        Files.copy((File)oldIdFile, (File)idFile);
        String uuid = Files.readFirstLine((File)idFile, (Charset)Charsets.UTF_8);
        return UUID.fromString(uuid);
    }
}

