/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;

public class URLUtil {
    public static URI toURI(String s) throws URISyntaxException {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            URL url;
            try {
                url = new URL(s);
            }
            catch (MalformedURLException e1) {
                throw e;
            }
            if (!s.equals(url.toString())) {
                try {
                    return url.toURI();
                }
                catch (URISyntaxException e1) {
                    // empty catch block
                }
            }
            try {
                return new URI(url.getProtocol(), url.getAuthority(), URLUtil.urlDecode(url.getPath()), URLUtil.encodeQuery(url.getQuery()), url.getRef());
            }
            catch (URISyntaxException e1) {
                throw e;
            }
        }
    }

    public static URL toURL(String s) throws MalformedURLException {
        try {
            URI uri = URLUtil.toURI(s);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        catch (RuntimeException e) {
            return new URL(s);
        }
    }

    public static String encode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encodeQuery(String query) {
        return query == null ? null : query.replace(" ", "+");
    }

    public static String toggleHttps(String url) {
        if (url.startsWith("http:")) {
            url = "https:" + url.substring("http:".length());
        } else if (url.startsWith("https:")) {
            url = "http:" + url.substring("https:".length());
        }
        return url;
    }

    public static String appendPath(String ... urlParts) {
        if (urlParts == null || urlParts.length == 0) {
            return null;
        }
        if (urlParts.length == 1) {
            return urlParts[0];
        }
        StringBuilder url = new StringBuilder();
        String[] stringArray = urlParts;
        int n = urlParts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (url.length() > 0 && url.charAt(url.length() - 1) != '/' && (part.length() == 0 || part.charAt(0) != '/') || url.length() == 0 && part.length() == 0) {
                url.append('/');
            }
            url.append(part);
            ++n2;
        }
        return url.toString();
    }

    public static String urlEncode(String s) {
        try {
            return s == null ? null : URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MarketplaceClientCore.error(e);
            return s;
        }
    }

    public static String urlDecode(String path) {
        try {
            return path == null ? null : URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return path;
        }
    }

    public static String setScheme(String url, String scheme) {
        int schemeSeparator = url.indexOf(":");
        if (schemeSeparator == -1) {
            throw new IllegalArgumentException();
        }
        return String.valueOf(scheme) + url.substring(schemeSeparator);
    }
}

