/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.internal.mpc.core.util.TextUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientToolTip;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;

public class CatalogToolTip
extends GradientToolTip {
    private Image image;
    private final CatalogDescriptor catalogDescriptor;
    private final Label label;

    public static void attachCatalogToolTip(Label label, CatalogDescriptor catalogDescriptor) {
        new CatalogToolTip(label, catalogDescriptor);
    }

    private CatalogToolTip(Label label, CatalogDescriptor catalogDescriptor) {
        super((Control)label);
        this.label = label;
        this.catalogDescriptor = catalogDescriptor;
    }

    protected Composite createToolTipArea(Event event, Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).equalWidth(false).applyTo(parent);
        this.createIcon(parent);
        this.createLabel(parent);
        this.createDescription(parent);
        return parent;
    }

    private void createDescription(Composite parent) {
        Control icon = parent.getChildren()[0];
        int iconWidth = icon.computeSize((int)-1, (int)-1).x;
        Control label = parent.getChildren()[1];
        int labelWidth = label.computeSize((int)-1, (int)-1).x;
        int wHint = iconWidth + 5 + labelWidth;
        Label descriptionLabel = new Label(parent, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(wHint, -1).applyTo((Control)descriptionLabel);
        descriptionLabel.setBackground(null);
        String description = this.catalogDescriptor.getDescription() == null ? "" : TextUtil.escapeText((String)this.catalogDescriptor.getDescription());
        descriptionLabel.setText(description);
    }

    private void createLabel(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        FontDescriptor h1FontDescriptor = this.createFontDescriptor(1, 1.35f);
        nameLabel.setFont(h1FontDescriptor.createFont((Device)parent.getDisplay()));
        nameLabel.setText(TextUtil.escapeText((String)this.catalogDescriptor.getLabel()));
        nameLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameLabel);
    }

    private void createIcon(Composite parent) {
        this.image = this.label.getImage();
        if (this.image == null) {
            ImageRegistry registry = MarketplaceClientUiPlugin.getInstance().getImageRegistry();
            this.image = registry.get("NO_ICON_PROVIDED_CATALOG");
        }
        Label iconLabel = new Label(parent, 0);
        iconLabel.setImage(this.image);
        iconLabel.setBackground(null);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)iconLabel);
    }

    private FontDescriptor createFontDescriptor(int style, float heightMultiplier) {
        Font baseFont = JFaceResources.getDialogFont();
        FontData[] fontData = baseFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < newFontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), (int)((float)fontData[i].getHeight() * heightMultiplier), fontData[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])newFontData);
    }
}

