/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

@Command(usage="usage_RebuildRefTree")
class RebuildRefTree
extends TextBuiltin {
    @Option(name="--enable", usage="usage_RebuildRefTreeEnable")
    boolean enable;
    private String txnNamespace;
    private String txnCommitted;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result;

    RebuildRefTree() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Exception {
        var1_1 = null;
        var2_3 = null;
        try {
            block32: {
                block29: {
                    reader = this.db.newObjectReader();
                    try {
                        block31: {
                            rw = new RevWalk(reader);
                            try {
                                block30: {
                                    inserter = this.db.newObjectInserter();
                                    refDb = this.db.getRefDatabase();
                                    if (refDb instanceof RefTreeDatabase) {
                                        d = (RefTreeDatabase)refDb;
                                        refDb = d.getBootstrap();
                                        this.txnNamespace = d.getTxnNamespace();
                                        this.txnCommitted = d.getTxnCommitted();
                                    } else {
                                        d = new RefTreeDatabase(this.db, refDb);
                                        this.txnNamespace = d.getTxnNamespace();
                                        this.txnCommitted = d.getTxnCommitted();
                                    }
                                    this.errw.format("Rebuilding %s from %s", new Object[]{this.txnCommitted, refDb.getClass().getSimpleName()});
                                    this.errw.println();
                                    this.errw.flush();
                                    b = new CommitBuilder();
                                    ref = refDb.exactRef(this.txnCommitted);
                                    update = refDb.newUpdate(this.txnCommitted, true);
                                    if (ref != null && ref.getObjectId() != null) {
                                        oldId = ref.getObjectId();
                                        update.setExpectedOldObjectId((AnyObjectId)oldId);
                                        b.setParentId((AnyObjectId)oldId);
                                        oldTreeId = rw.parseCommit((AnyObjectId)oldId).getTree();
                                    } else {
                                        update.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
                                        oldTreeId = ObjectId.zeroId();
                                    }
                                    tree = this.rebuild(refDb);
                                    b.setTreeId((AnyObjectId)tree.writeTree(inserter));
                                    b.setAuthor(new PersonIdent(this.db));
                                    b.setCommitter(b.getAuthor());
                                    if (!b.getTreeId().equals((AnyObjectId)oldTreeId)) break block29;
                                    if (inserter == null) break block30;
                                    inserter.close();
                                }
                                if (rw == null) break block31;
                            }
                            catch (Throwable var2_4) {
                                if (var1_1 == null) {
                                    var1_1 = var2_4;
                                } else if (var1_1 != var2_4) {
                                    var1_1.addSuppressed(var2_4);
                                }
                                if (rw == null) throw var1_1;
                                rw.close();
                                throw var1_1;
                            }
                            rw.close();
                        }
                        if (reader == null) return;
                    }
                    catch (Throwable var2_5) {
                        if (var1_1 == null) {
                            var1_1 = var2_5;
                        } else if (var1_1 != var2_5) {
                            var1_1.addSuppressed(var2_5);
                        }
                        if (reader == null) throw var1_1;
                        reader.close();
                        throw var1_1;
                    }
                    reader.close();
                    return;
                }
                ** try [egrp 6[TRYBLOCK] [1 : 347->510)] { 
lbl73:
                // 1 sources

                update.setNewObjectId((AnyObjectId)inserter.insert(b));
                inserter.flush();
                result = update.update(rw);
                switch (RebuildRefTree.$SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result()[result.ordinal()]) {
                    case 4: 
                    case 6: {
                        break;
                    }
                    default: {
                        throw RebuildRefTree.die(String.format("%s: %s", new Object[]{update.getName(), result}));
                    }
                }
                if (this.enable && !(this.db.getRefDatabase() instanceof RefTreeDatabase)) {
                    cfg = this.db.getConfig();
                    cfg.setInt("core", null, "repositoryformatversion", 1);
                    cfg.setString("extensions", null, "refStorage", "reftree");
                    cfg.save();
                    this.errw.println("Enabled reftree.");
                    this.errw.flush();
                }
                break block32;
lbl89:
                // 1 sources

                finally {
                    if (inserter != null) {
                        inserter.close();
                    }
                }
            }
            if (rw != null) {
                rw.close();
            }
            if (reader == null) return;
            reader.close();
            return;
        }
        catch (Throwable var2_6) {
            if (var1_1 == null) {
                var1_1 = var2_6;
                throw var1_1;
            }
            if (var1_1 == var2_6) throw var1_1;
            var1_1.addSuppressed(var2_6);
            throw var1_1;
        }
    }

    private RefTree rebuild(RefDatabase refdb) throws IOException {
        RefTree tree = RefTree.newEmptyTree();
        ArrayList<org.eclipse.jgit.internal.storage.reftree.Command> cmds = new ArrayList<org.eclipse.jgit.internal.storage.reftree.Command>();
        Ref head = refdb.exactRef("HEAD");
        if (head != null) {
            cmds.add(new org.eclipse.jgit.internal.storage.reftree.Command(null, head));
        }
        for (Ref r : refdb.getRefs()) {
            if (r.getName().equals(this.txnCommitted) || r.getName().equals("HEAD") || r.getName().startsWith(this.txnNamespace)) continue;
            cmds.add(new org.eclipse.jgit.internal.storage.reftree.Command(null, this.db.getRefDatabase().peel(r)));
        }
        tree.apply(cmds);
        return tree;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result() {
        if ($SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result;
        }
        int[] nArray = new int[RefUpdate.Result.values().length];
        try {
            nArray[RefUpdate.Result.FAST_FORWARD.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.FORCED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.IO_FAILURE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.LOCK_FAILURE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NEW.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NOT_ATTEMPTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NO_CHANGE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_CURRENT_BRANCH.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_MISSING_OBJECT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_OTHER_REASON.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.RENAMED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result = nArray;
        return nArray;
    }
}

