/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.Serializable;
import java.util.Collection;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IFaceletTagRecord
extends Serializable {
    public String getURI();

    public int getNumTags();

    public Collection<? extends FaceletTaglibTag> getTags();

    public FaceletTaglibTag getTag(String var1);

    public TagRecordDescriptor getDescriptor();

    public void addListener(ITagRecordChangeListener var1);

    public void removeListener(ITagRecordChangeListener var1);

    public static interface ITagRecordChangeListener {
        public void changed(TagRecordChangeEvent var1);
    }

    public static class JarTagRecordDescriptor
    extends TagRecordDescriptor {
        private final IResource _resourceJar;
        private final String _entryName;
        private final IPath _absPath;

        public JarTagRecordDescriptor(IResource resourceJar, String entryName) {
            super(TagRecordDescriptor.Source.JAR);
            this._resourceJar = resourceJar;
            this._entryName = entryName;
            this._absPath = resourceJar.getLocation();
        }

        public JarTagRecordDescriptor(IPath absPath, String entryName) {
            super(TagRecordDescriptor.Source.JAR);
            this._resourceJar = null;
            this._absPath = absPath;
            this._entryName = entryName;
        }

        public IResource getResource() {
            return this._resourceJar;
        }

        public IPath getPath() {
            return this._absPath;
        }

        public final String getEntryName() {
            return this._entryName;
        }
    }

    public static class TagRecordChangeEvent
    extends EventObject {
        private static final long serialVersionUID = 5655356157624922019L;

        public TagRecordChangeEvent(IFaceletTagRecord source) {
            super(source);
        }
    }

    public static abstract class TagRecordDescriptor {
        private final Source _source;

        public TagRecordDescriptor(Source source) {
            this._source = source;
        }

        public Source getSource() {
            return this._source;
        }

        public abstract IResource getResource();

        public abstract IPath getPath();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Source {
            WORKSPACE_FILE,
            WORKSPACE_FOLDER,
            JAR;

        }
    }

    public static class WorkspaceTagRecordDescriptor
    extends TagRecordDescriptor {
        private final IResource _resource;

        public WorkspaceTagRecordDescriptor(IFile file) {
            super(TagRecordDescriptor.Source.WORKSPACE_FILE);
            this._resource = file;
        }

        public WorkspaceTagRecordDescriptor(IFolder folder) {
            super(TagRecordDescriptor.Source.WORKSPACE_FOLDER);
            this._resource = folder;
        }

        public IResource getResource() {
            return this._resource;
        }

        public IPath getPath() {
            return this._resource.getLocation();
        }
    }
}

