/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtil {
    private static Logger _logger = PDPlugin.getLogger(DOMUtil.class);

    private static List getAncesters(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        while (node != null) {
            list.add(node);
            if (node instanceof Document) break;
            node = node.getParentNode();
        }
        if (node == null) {
            return null;
        }
        Collections.reverse(list);
        list.add(null);
        return list;
    }

    public static Node findCommonAncester(Node node1, Node node2) {
        List list1 = DOMUtil.getAncesters(node1);
        if (list1 == null) {
            return null;
        }
        List list2 = DOMUtil.getAncesters(node2);
        if (list2 == null) {
            return null;
        }
        if (list1.get(0) != list2.get(0)) {
            return null;
        }
        Node common = (Node)list1.get(0);
        int i = 1;
        while (true) {
            Node p1 = (Node)list1.get(i);
            Node p2 = (Node)list2.get(i);
            if (p1 == null || p2 == null) {
                return common;
            }
            if (p1 != p2) {
                return common;
            }
            common = p1;
            ++i;
        }
    }

    public static Node cloneNodeDeepIgnoreError(Document destDoc, Node sourceNode) {
        switch (sourceNode.getNodeType()) {
            case 1: {
                Element sourceEle = (Element)sourceNode;
                Element resultEle = destDoc.createElement(sourceEle.getTagName());
                NamedNodeMap attrs = sourceEle.getAttributes();
                int i = 0;
                int size = attrs.getLength();
                while (i < size) {
                    Attr a = (Attr)attrs.item(i);
                    try {
                        resultEle.setAttribute(a.getName(), a.getValue());
                    }
                    catch (Exception ex) {
                        _logger.info("DOMUtil.ExceptionWhileCloningNode", (Throwable)ex);
                    }
                    ++i;
                }
                NodeList children = sourceEle.getChildNodes();
                int i2 = 0;
                int size2 = children.getLength();
                while (i2 < size2) {
                    Node n = children.item(i2);
                    Node d = DOMUtil.cloneNodeDeepIgnoreError(destDoc, n);
                    if (d != null) {
                        try {
                            resultEle.appendChild(d);
                        }
                        catch (Exception ex) {
                            _logger.info("DOMUtil.ExceptionWhileCloningNode", (Throwable)ex);
                        }
                    }
                    ++i2;
                }
                return resultEle;
            }
            case 3: {
                Text txt = destDoc.createTextNode(sourceNode.getNodeValue());
                if (txt instanceof IDOMText && sourceNode instanceof IDOMText) {
                    try {
                        ((IDOMText)txt).setSource(((IDOMText)sourceNode).getSource());
                    }
                    catch (Exception exception) {}
                }
                return txt;
            }
            case 4: {
                return destDoc.createCDATASection(sourceNode.getNodeValue());
            }
        }
        return null;
    }

    public static Node cloneNodeDeep(Document destDoc, Node sourceNode) {
        switch (sourceNode.getNodeType()) {
            case 1: {
                Element sourceEle = (Element)sourceNode;
                Element resultEle = destDoc.createElement(sourceEle.getTagName());
                NamedNodeMap attrs = sourceEle.getAttributes();
                int i = 0;
                int size = attrs.getLength();
                while (i < size) {
                    Attr a = (Attr)attrs.item(i);
                    resultEle.setAttribute(a.getName(), a.getValue());
                    ++i;
                }
                NodeList children = sourceEle.getChildNodes();
                int i2 = 0;
                int size2 = children.getLength();
                while (i2 < size2) {
                    Node n = children.item(i2);
                    Node d = DOMUtil.cloneNodeDeep(destDoc, n);
                    if (d != null) {
                        resultEle.appendChild(d);
                    }
                    ++i2;
                }
                return resultEle;
            }
            case 3: {
                Text txt = destDoc.createTextNode(sourceNode.getNodeValue());
                if (txt instanceof IDOMText && sourceNode instanceof IDOMText) {
                    try {
                        ((IDOMText)txt).setSource(((IDOMText)sourceNode).getSource());
                    }
                    catch (Exception ex) {
                        _logger.info("DOMUtil.ExceptionWhileCloningNode", (Throwable)ex);
                    }
                }
                return txt;
            }
            case 4: {
                return destDoc.createCDATASection(sourceNode.getNodeValue());
            }
        }
        return null;
    }

    public static boolean isAncester(Node ancester, Node child) {
        while (child != null) {
            if (child == ancester) {
                return true;
            }
            child = child.getParentNode();
        }
        return false;
    }

    public static Node insertNode(IDOMPosition domPosition, Node node) {
        IDOMPosition position = DOMPositionHelper.splitText(domPosition);
        if (position == null || position.getContainerNode() == null) {
            return null;
        }
        if (position.getNextSiblingNode() == null) {
            position.getContainerNode().appendChild(node);
        } else {
            position.getContainerNode().insertBefore(node, position.getNextSiblingNode());
        }
        return node;
    }
}

