/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.exporter.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.jubula.client.core.exporter.junit.JUnitXMLGeneratorOperations;
import org.eclipse.jubula.client.core.exporter.junit.JUnitXMLSkippedGenerator;
import org.eclipse.jubula.client.core.exporter.junit.SuiteFinderOperation;
import org.eclipse.jubula.client.core.exporter.junitmodel.ObjectFactory;
import org.eclipse.jubula.client.core.exporter.junitmodel.Testcase;
import org.eclipse.jubula.client.core.exporter.junitmodel.Testsuite;
import org.eclipse.jubula.client.core.exporter.junitmodel.Testsuites;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.testresult.export.ITestResultExporter;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TestResultNodeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JunitXMLWriter
implements ITestResultExporter {
    private static Logger log = LoggerFactory.getLogger(JunitXMLWriter.class);
    private ObjectFactory m_objF;
    private Testsuites m_project;
    private ITestResult m_testResult;
    private TestResultNode m_resultNode;
    private List<TestResultNode> m_testSuiteList;

    private void generateHead() {
        this.setTestSuites();
        this.setSuitesData(this.m_resultNode, this.m_project, this.m_testSuiteList);
    }

    private void setTestSuites() {
        this.m_project = this.m_objF.createTestsuites();
        this.m_project.setTime(this.m_testResult.getStartTime().toString());
        this.m_project.setName(this.m_testResult.getProjectName());
    }

    private void setTestResult(ITestResult testResult) {
        this.m_testResult = testResult;
    }

    public File generateFileForExport(String path, String filename) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        File fileToWrite = new File(path, String.valueOf(filename) + "-junit" + ".xml");
        return fileToWrite;
    }

    private String convertTime(long l) {
        String convertedtime = Double.toString((double)l / 1000.0);
        return convertedtime;
    }

    private void findTestcasesForTestsuite() {
        int count = 0;
        List<Testsuite> tempSuiteList = this.m_project.getTestsuite();
        for (TestResultNode testResultNode : this.m_testSuiteList) {
            List testcaseList = testResultNode.getResultNodeList();
            for (TestResultNode testRes : testcaseList) {
                if (testRes.getNode() instanceof ITestCasePO) {
                    this.createJAXBTestCase(testRes, tempSuiteList, count);
                    continue;
                }
                if (testRes.getNode() instanceof ICapPO) {
                    this.createJAXBTestCase(testRes, tempSuiteList, count);
                    continue;
                }
                if (!(testRes.getNode() instanceof IControllerPO)) continue;
                this.createJAXBTestCase(testRes, tempSuiteList, count);
            }
            ++count;
        }
    }

    private void createJAXBTestCase(TestResultNode testRes, List<Testsuite> tempSuiteList, int count) {
        Testcase testCase = this.m_objF.createTestcase();
        if (testRes.getNode() instanceof IControllerPO) {
            testCase.setName("(Condition) " + testRes.getName());
        } else {
            testCase.setName(testRes.getName());
        }
        testCase.setTime(this.convertTime(testRes.getDuration(this.m_testResult.getEndTime())));
        testCase.setStatus(testRes.getStatusString());
        if (testRes.getStatus() == 5) {
            this.testCaseHandling(testRes, testCase, false);
        } else if (testRes.getStatus() == 20 || testRes.getStatus() == 0) {
            this.testCaseHandling(testRes, testCase, true);
            testCase.setTime("0");
        } else if (testRes.getStatus() != 1) {
            this.testCaseHandling(testRes, testCase, false);
        }
        tempSuiteList.get(count).getTestsuiteOrPropertiesOrTestcase().add(testCase);
    }

    private void setSuitesData(TestResultNode testRes, Testsuites project, List<TestResultNode> list) {
        SuiteFinderOperation suiteFinder = new SuiteFinderOperation(testRes, project, list, this.m_testResult);
        TestResultNodeTraverser testResTraverser = new TestResultNodeTraverser(testRes, (ITreeNodeOperation)suiteFinder);
        testResTraverser.traverse();
    }

    private void testCaseHandling(TestResultNode node, Testcase testCase, boolean skipped) {
        Object jxgOperat = null;
        jxgOperat = skipped ? new JUnitXMLSkippedGenerator(node, testCase) : new JUnitXMLGeneratorOperations(node, testCase);
        TestResultNodeTraverser testResTraverser = new TestResultNodeTraverser(node, (ITreeNodeOperation)jxgOperat);
        testResTraverser.traverse();
    }

    public void initiliaze(ITestResult result) {
        this.m_objF = new ObjectFactory();
        this.setTestResult(result);
        this.m_resultNode = result.getRootResultNode();
        this.m_testSuiteList = new ArrayList<TestResultNode>();
        this.generateHead();
    }

    public void writeTestResult(String path, String filename) {
        this.findTestcasesForTestsuite();
        JAXBContext jaxbCtx = null;
        try {
            jaxbCtx = JAXBContext.newInstance((String)this.m_project.getClass().getPackage().getName());
            Marshaller marshaller = null;
            marshaller = jaxbCtx.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.m_project, this.generateFileForExport(path, filename).getAbsoluteFile());
        }
        catch (IOException | JAXBException e) {
            log.error("Exception while writing TestResults to file", e);
        }
    }
}

