/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.util;

import java.awt.Rectangle;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.util.Rounding;

public class NodeBounds {
    private NodeBounds() {
    }

    public static boolean checkIfContains(Point2D point, Node n) throws IllegalStateException {
        EventThreadQueuerJavaFXImpl.checkEventThread();
        if (n.getScene() == null) {
            return false;
        }
        Point2D nodePos = n.localToScreen(0.0, 0.0);
        if (nodePos == null) {
            return false;
        }
        return n.contains(n.screenToLocal(point.getX(), point.getY()));
    }

    public static Rectangle getAbsoluteBounds(Node node) throws NullPointerException, IllegalStateException {
        EventThreadQueuerJavaFXImpl.checkEventThread();
        Bounds bounds = node.localToScreen(node.getBoundsInLocal());
        return new Rectangle(Rounding.round(bounds.getMinX()), Rounding.round(bounds.getMinY()), Rounding.round(bounds.getWidth()), Rounding.round(bounds.getHeight()));
    }

    public static Rectangle getRelativeBounds(Node node, Node relativeTo) throws NullPointerException, IllegalStateException {
        EventThreadQueuerJavaFXImpl.checkEventThread();
        Rectangle bounds = NodeBounds.getAbsoluteBounds(node);
        Rectangle otherAbsoluteBounds = NodeBounds.getAbsoluteBounds(relativeTo);
        bounds.translate(-otherAbsoluteBounds.x, -otherAbsoluteBounds.y);
        return bounds;
    }
}

